/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots;

import java.util.Set;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotMenu;
import net.darkhax.botanypots.commands.BotanyPotsCommands;
import net.darkhax.botanypots.data.recipes.crop.BasicCropSerializer;
import net.darkhax.botanypots.data.recipes.fertilizer.BasicFertilizerSerializer;
import net.darkhax.botanypots.data.recipes.potinteraction.BasicPotInteractionSerializer;
import net.darkhax.botanypots.data.recipes.soil.BasicSoilSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class Content
extends RegistryDataProvider {
    public Content() {
        super("botanypots");
        this.withItemTab(() -> new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation("botanypots", "terracotta_botany_pot"))));
        this.withAutoItemBlocks();
        this.recipeTypes.add("soil");
        this.recipeTypes.add("crop");
        this.recipeTypes.add("pot_interaction");
        this.recipeTypes.add("fertilizer");
        this.recipeSerializers.add(() -> BasicSoilSerializer.SERIALIZER, "soil");
        this.recipeSerializers.add(() -> BasicCropSerializer.SERIALIZER, "crop");
        this.recipeSerializers.add(() -> BasicPotInteractionSerializer.INSTANCE, "pot_interaction");
        this.recipeSerializers.add(() -> BasicFertilizerSerializer.SERIALIZER, "fertilizer");
        this.blocks.add(() -> new BlockBotanyPot(false), "terracotta_botany_pot");
        this.blocks.add(() -> new BlockBotanyPot(true), "terracotta_hopper_botany_pot");
        for (DyeColor color : DyeColor.values()) {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().mapColor(color).strength(1.25f, 4.2f).noOcclusion();
            this.blocks.add(() -> new BlockBotanyPot(properties, false), color.getName() + "_terracotta_botany_pot");
            this.blocks.add(() -> new BlockBotanyPot(properties, true), color.getName() + "_terracotta_hopper_botany_pot");
            this.blocks.add(() -> new BlockBotanyPot(properties, false), color.getName() + "_concrete_botany_pot");
            this.blocks.add(() -> new BlockBotanyPot(properties, true), color.getName() + "_concrete_hopper_botany_pot");
            this.blocks.add(() -> new BlockBotanyPot(properties, false), color.getName() + "_glazed_terracotta_botany_pot");
            this.blocks.add(() -> new BlockBotanyPot(properties, true), color.getName() + "_glazed_terracotta_hopper_botany_pot");
        }
        this.blockEntities.add(() -> (BlockEntityType)Services.CONSTRUCTS.blockEntityType(BlockEntityBotanyPot.class, (pos, state) -> new BlockEntityBotanyPot((BlockEntityType)BlockEntityBotanyPot.POT_TYPE.get(), (BlockPos)pos, (BlockState)state), this::getAllPots).get(), "botany_pot");
        this.menus.add(() -> Services.CONSTRUCTS.menuType(BotanyPotMenu::fromNetwork), "pot_menu");
        this.commands.add(BotanyPotsCommands::new, "commands");
    }

    private Set<Block> getAllPots() {
        return this.blocks.getEntries().values().stream().filter(b -> b instanceof BlockBotanyPot).collect(Collectors.toSet());
    }
}

