/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.addons.rei;

import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.BotanyPotsCommon;
import net.darkhax.botanypots.addons.rei.CropDisplayCategory;
import net.darkhax.botanypots.addons.rei.ui.BasicCropDisplay;
import net.darkhax.botanypots.addons.rei.ui.CropDisplay;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class REIPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<CropDisplay> SOIL = CategoryIdentifier.of((String)"botanypots", (String)"soil");
    public static final CategoryIdentifier<CropDisplay> CROP = CategoryIdentifier.of((String)"botanypots", (String)"crop");

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new CropDisplayCategory(SOIL));
        registry.add((DisplayCategory)new CropDisplayCategory(CROP));
        EntryIngredient.Builder builder = EntryIngredient.builder();
        for (Item potItem : BotanyPotsCommon.content.items) {
            BlockItem blockItem;
            Block block;
            if (!(potItem instanceof BlockItem) || !((block = (blockItem = (BlockItem)potItem).getBlock()) instanceof BlockBotanyPot)) continue;
            BlockBotanyPot pot = (BlockBotanyPot)block;
            builder.add(EntryStacks.of((ItemLike)potItem));
        }
        registry.addWorkstations(CROP, new EntryIngredient[]{builder.build()});
    }

    public void registerDisplays(DisplayRegistry registry) {
        RecipeManager recipeManager = registry.getRecipeManager();
        List soils = BotanyPotHelper.getAllRecipes(recipeManager, (RecipeType)BotanyPotHelper.SOIL_TYPE.get());
        List<RecipeHolder<RecipeHolder>> crops = BotanyPotHelper.getAllRecipes(recipeManager, (RecipeType)BotanyPotHelper.CROP_TYPE.get());
        crops.forEach(crop -> {
            List<CropDisplay> displays = BasicCropDisplay.getCropRecipes((RecipeHolder<Crop>)crop, soils);
            for (CropDisplay display : displays) {
                registry.add((Display)display, crop);
            }
        });
    }
}

