/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block;

import com.mojang.serialization.MapCodec;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.block.IBindRenderLayer;
import net.darkhax.bookshelf.api.block.InventoryBlock;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.recipes.fertilizer.Fertilizer;
import net.darkhax.botanypots.data.recipes.potinteraction.PotInteraction;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockBotanyPot
extends InventoryBlock
implements SimpleWaterloggedBlock,
IBindRenderLayer {
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    private static final BlockBehaviour.Properties DEFAULT_PROPERTIES = BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).strength(1.25f, 4.2f).noOcclusion().lightLevel(state -> (Integer)state.getValue((Property)BlockStateProperties.LEVEL));
    private final boolean hasInventory;

    public BlockBotanyPot(boolean hasInventory) {
        this(DEFAULT_PROPERTIES, hasInventory);
    }

    public BlockBotanyPot(BlockBehaviour.Properties properties, boolean hasInventory) {
        super(properties);
        BlockState defaultState = (BlockState)this.getStateDefinition().any();
        defaultState = (BlockState)defaultState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(0));
        defaultState = (BlockState)defaultState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH);
        this.registerDefaultState(defaultState);
        this.hasInventory = hasInventory;
    }

    public boolean hasInventory() {
        return this.hasInventory;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        throw new RuntimeException("Codecs for this block have not been implemented yet. Sorry :(");
    }

    public RenderShape getRenderShape(BlockState $$0) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos placedPos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(placedPos);
        BlockState placedState = (BlockState)super.getStateForPlacement(context).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        if (context.getNearestLookingDirection().getAxis().isHorizontal()) {
            placedState = (BlockState)placedState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
        }
        return placedState;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        int n;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BlockEntityBotanyPot) {
            BlockEntityBotanyPot pot = (BlockEntityBotanyPot)blockEntity;
            n = pot.getComparatorLevel();
        } else {
            n = 0;
        }
        return n;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED, BlockStateProperties.LEVEL, BlockStateProperties.HORIZONTAL_FACING});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityBotanyPot((BlockEntityType)BlockEntityBotanyPot.POT_TYPE.get(), pos, state);
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BlockEntityBotanyPot) {
            RecipeHolder<Fertilizer> fertilizerRecipe;
            BlockEntityBotanyPot potEntity = (BlockEntityBotanyPot)blockEntity;
            ItemStack heldStack = player.getItemInHand(hand);
            if (potEntity.areGrowthConditionsMet() && potEntity.getGrowthTime() > 0 && !potEntity.doneGrowing && (fertilizerRecipe = BotanyPotHelper.findFertilizer(state, world, pos, player, hand, heldStack, potEntity)) != null) {
                ((Fertilizer)fertilizerRecipe.value()).apply(state, world, pos, player, hand, heldStack, potEntity);
                return InteractionResult.CONSUME;
            }
            RecipeHolder<PotInteraction> interactionRecipe = BotanyPotHelper.findPotInteraction(state, world, pos, player, hand, heldStack, potEntity);
            if (interactionRecipe != null) {
                ((PotInteraction)interactionRecipe.value()).apply(state, world, pos, player, hand, heldStack, potEntity);
                return InteractionResult.CONSUME;
            }
            if (!player.isCrouching() && !potEntity.isHopper() && potEntity.doneGrowing && potEntity.getCrop() != null) {
                if (!world.isClientSide) {
                    for (ItemStack drop : BotanyPotHelper.generateDrop(potEntity.rng, world, pos, potEntity, potEntity.getCrop())) {
                        BlockBotanyPot.popResource((Level)world, (BlockPos)pos, (ItemStack)drop);
                    }
                    potEntity.resetGrowth();
                }
                return InteractionResult.CONSUME;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Services.INVENTORY_HELPER.openMenu(serverPlayer, (MenuProvider)potEntity, buf -> BookshelfByteBufs.BLOCK_POS.write(buf, (Object)pos));
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(state, world, pos, player, hand, hitResult);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level worldLevel, BlockState state, BlockEntityType<T> blockEntityType) {
        return BlockBotanyPot.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityBotanyPot.POT_TYPE.get()), BlockEntityBotanyPot::tickPot);
    }

    public RenderType getRenderLayerToBind() {
        return RenderType.cutout();
    }
}

