/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.block.entity.WorldlyInventoryBlockEntity;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.inventory.ContainerInventoryAccess;
import net.darkhax.bookshelf.api.inventory.IInventoryAccess;
import net.darkhax.bookshelf.api.registry.RegistryObject;
import net.darkhax.bookshelf.api.util.WorldHelper;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.Constants;
import net.darkhax.botanypots.block.BlockBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotContainer;
import net.darkhax.botanypots.block.inv.BotanyPotMenu;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityBotanyPot
extends WorldlyInventoryBlockEntity<BotanyPotContainer> {
    public static final CachedSupplier<BlockEntityType<BlockEntityBotanyPot>> POT_TYPE = RegistryObject.deferred((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"botanypots", (String)"botany_pot").cast();
    private static final Component DEFAULT_NAME = Component.translatable((String)"block.botanypots.terracotta_botany_pot");
    protected int growthTime = -1;
    protected boolean doneGrowing = false;
    protected int prevComparatorLevel = 0;
    protected int comparatorLevel = 0;
    protected int harvestDelay = -1;
    protected int exportDelay = -1;
    final Random rng = new Random();
    private long rngSeed;
    private boolean isHopper = false;

    public BlockEntityBotanyPot(BlockEntityType potType, BlockPos pos, BlockState state) {
        super(potType, pos, state);
        this.refreshRandom();
        Block block = state.getBlock();
        if (block instanceof BlockBotanyPot) {
            BlockBotanyPot pot = (BlockBotanyPot)block;
            this.isHopper = pot.hasInventory();
        }
    }

    public boolean isHopper() {
        return this.isHopper;
    }

    public void refreshRandom() {
        this.rngSeed = Constants.RANDOM.nextLong();
        this.rng.setSeed(this.rngSeed);
    }

    @Nullable
    public RecipeHolder<Crop> getCropHolder() {
        return ((BotanyPotContainer)this.getInventory()).getCrop();
    }

    @Nullable
    public RecipeHolder<Soil> getSoilHolder() {
        return ((BotanyPotContainer)this.getInventory()).getSoil();
    }

    @Nullable
    public Crop getCrop() {
        RecipeHolder<Crop> cropHolder = this.getCropHolder();
        return cropHolder != null ? (Crop)cropHolder.value() : null;
    }

    @Nullable
    public Soil getSoil() {
        RecipeHolder<Soil> soilHolder = this.getSoilHolder();
        return soilHolder != null ? (Soil)soilHolder.value() : null;
    }

    public boolean isGrowing() {
        return this.growthTime > 0;
    }

    public boolean areGrowthConditionsMet() {
        return BotanyPotHelper.canCropGrow(this.level, this.getBlockPos(), this, this.getSoil(), this.getCrop());
    }

    public boolean isCropHarvestable() {
        return this.doneGrowing;
    }

    public int getLightLevel() {
        Soil soil = this.getSoil();
        Crop crop = this.getCrop();
        int soilLight = soil != null ? soil.getLightLevel(this.level, this.getBlockPos(), this) : 0;
        int cropLight = crop != null ? crop.getLightLevel(this.level, this.getBlockPos(), this) : 0;
        return Math.max(soilLight, cropLight);
    }

    public int getGrowthTime() {
        return this.growthTime;
    }

    public int getComparatorLevel() {
        return this.comparatorLevel;
    }

    public boolean isValidSoil(ItemStack stack) {
        return BotanyPotHelper.findSoil(this.level, this.getBlockPos(), this, stack) != null;
    }

    public boolean isValidSeed(ItemStack stack) {
        return BotanyPotHelper.findCrop(this.level, this.getBlockPos(), this, stack) != null;
    }

    public boolean attemptAutoHarvest() {
        if (this.getLevel() != null && !this.getLevel().isClientSide && this.getCrop() != null) {
            ContainerInventoryAccess inventory = new ContainerInventoryAccess((Container)((BotanyPotContainer)this.getInventory()));
            this.rng.setSeed(this.rngSeed);
            List<ItemStack> drops = BotanyPotHelper.generateDrop(this.rng, this.level, this.getBlockPos(), this, this.getCrop());
            if (drops.isEmpty()) {
                return true;
            }
            boolean didCollect = false;
            for (ItemStack drop : drops) {
                if (drop.isEmpty()) continue;
                int originalSize = drop.getCount();
                for (int slot : BotanyPotContainer.STORAGE_SLOT) {
                    if (drop.isEmpty()) break;
                    drop = inventory.insert(slot, drop, Direction.UP, true, true);
                }
                if (drop.getCount() == originalSize) continue;
                didCollect = true;
            }
            return didCollect;
        }
        return false;
    }

    private void attemptExport() {
        IInventoryAccess exportTo;
        if (this.getLevel() != null && !this.getLevel().isClientSide && (exportTo = Services.INVENTORY_HELPER.getInventory(this.getLevel(), this.getBlockPos().below(), Direction.UP)) != null) {
            block0: for (int potSlotId : BotanyPotContainer.STORAGE_SLOT) {
                ItemStack potStack = ((BotanyPotContainer)this.getInventory()).getItem(potSlotId);
                if (potStack.isEmpty()) continue;
                for (int exportSlotId : exportTo.getAvailableSlots()) {
                    if (exportTo.insert(exportSlotId, potStack, Direction.UP, false).getCount() == potStack.getCount()) continue;
                    ((BotanyPotContainer)this.getInventory()).setItem(potSlotId, exportTo.insert(exportSlotId, potStack, Direction.UP, true));
                    continue block0;
                }
            }
        }
    }

    public static void tickPot(Level level, BlockPos pos, BlockState state, BlockEntityBotanyPot pot) {
        if (pot.isRemoved() || pot.getLevel() == null) {
            return;
        }
        ((BotanyPotContainer)pot.getInventory()).update();
        Soil soil = pot.getSoil();
        Crop crop = pot.getCrop();
        if (soil != null) {
            soil.onTick(level, pos, pot);
        }
        if (crop != null) {
            crop.onTick(level, pos, pot);
        }
        if (pot.isHopper()) {
            if (pot.exportDelay > 0) {
                --pot.exportDelay;
            }
            if (pot.harvestDelay > 0) {
                --pot.harvestDelay;
            }
            if (crop != null && pot.harvestDelay < 1 && pot.isCropHarvestable()) {
                if (pot.attemptAutoHarvest()) {
                    pot.resetGrowth();
                }
                pot.harvestDelay = 100;
            }
            if (pot.exportDelay < 1) {
                pot.attemptExport();
                pot.exportDelay = 20;
            }
        }
        if (soil != null && crop != null && pot.areGrowthConditionsMet()) {
            if (!pot.doneGrowing) {
                boolean finishedGrowing;
                ++pot.growthTime;
                soil.onGrowthTick(level, pos, pot, crop);
                crop.onGrowthTick(level, pos, pot, soil);
                pot.prevComparatorLevel = pot.comparatorLevel;
                pot.comparatorLevel = Mth.floor((float)(15.0f * ((float)pot.growthTime / (float)((BotanyPotContainer)pot.getInventory()).getRequiredGrowthTime())));
                boolean bl = finishedGrowing = pot.growthTime >= ((BotanyPotContainer)pot.getInventory()).getRequiredGrowthTime();
                if (pot.doneGrowing != finishedGrowing) {
                    pot.doneGrowing = finishedGrowing;
                    pot.markDirty();
                }
            }
        } else if (pot.growthTime != -1 || pot.doneGrowing || pot.comparatorLevel != 0) {
            pot.resetGrowth();
        }
        if (pot.comparatorLevel != pot.prevComparatorLevel) {
            pot.prevComparatorLevel = pot.comparatorLevel;
            pot.level.updateNeighbourForOutputSignal(pot.worldPosition, pot.getBlockState().getBlock());
        }
    }

    public void resetGrowth() {
        this.growthTime = -1;
        this.comparatorLevel = 0;
        this.prevComparatorLevel = 0;
        this.doneGrowing = false;
        this.refreshRandom();
        this.markDirty();
    }

    public void markDirty() {
        if (this.level != null && !this.level.isClientSide) {
            super.markDirty();
            WorldHelper.updateBlockEntity((BlockEntity)this, (boolean)false);
        }
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.growthTime = tag.getInt("GrowthTime");
        this.doneGrowing = tag.getBoolean("DoneGrowing");
        this.prevComparatorLevel = tag.getInt("PrevComparatorLevel");
        this.comparatorLevel = tag.getInt("ComparatorLevel");
        this.harvestDelay = tag.contains("HarvestDelay") ? tag.getInt("HarvestDelay") : -1;
        this.exportDelay = tag.contains("ExportDelay") ? tag.getInt("ExportDelay") : -1;
        this.rngSeed = tag.contains("RandomSeed") ? tag.getLong("RandomSeed") : Constants.RANDOM.nextLong();
        this.rng.setSeed(this.rngSeed);
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("GrowthTime", this.growthTime);
        tag.putBoolean("DoneGrowing", this.doneGrowing);
        tag.putInt("PrevComparatorLevel", this.prevComparatorLevel);
        tag.putInt("ComparatorLevel", this.comparatorLevel);
        tag.putInt("HarvestDelay", this.harvestDelay);
        tag.putInt("ExportDelay", this.exportDelay);
        tag.putLong("RandomSeed", this.rngSeed);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag updateTag = super.getUpdateTag();
        this.saveAdditional(updateTag);
        return updateTag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public BotanyPotContainer createInventory() {
        return new BotanyPotContainer(this);
    }

    protected Component getDefaultName() {
        return DEFAULT_NAME;
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory) {
        return new BotanyPotMenu(windowId, (BotanyPotContainer)this.getInventory(), inventory);
    }

    public void addGrowth(int nextIntInclusive) {
        this.growthTime += nextIntInclusive;
        this.markDirty();
    }
}

