/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.inv;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BotanyPotContainer
extends SimpleContainer
implements WorldlyContainer {
    public static final int SOIL_SLOT = 0;
    public static final int CROP_SLOT = 1;
    public static final int[] STORAGE_SLOT = IntStream.range(2, 14).toArray();
    public static final int[] EMPTY_SLOTS = new int[0];
    private final BlockEntityBotanyPot potEntity;
    @Nullable
    private RecipeHolder<Soil> soil = null;
    @Nullable
    private RecipeHolder<Crop> crop = null;
    private int requiredGrowthTime = -1;

    public BotanyPotContainer(BlockEntityBotanyPot potEntity) {
        super(14);
        this.potEntity = potEntity;
    }

    public ItemStack getSoilStack() {
        return this.getItem(0);
    }

    public ItemStack getCropStack() {
        return this.getItem(1);
    }

    public int getRequiredGrowthTime() {
        return this.requiredGrowthTime;
    }

    public BlockEntityBotanyPot getPotEntity() {
        return this.potEntity;
    }

    public void update() {
        boolean revalidateCrop;
        Level level = this.potEntity.getLevel();
        BlockPos pos = this.potEntity.getBlockPos();
        boolean revalidateSoil = this.soil == null && !this.getSoilStack().isEmpty() && BotanyPotHelper.findSoil(level, pos, this.potEntity, this.getSoilStack()) != null;
        boolean bl = revalidateCrop = this.crop == null && !this.getCropStack().isEmpty() && BotanyPotHelper.findCrop(level, pos, this.potEntity, this.getCropStack()) != null;
        if (revalidateSoil || revalidateCrop) {
            this.setChanged();
        }
    }

    public void setChanged() {
        super.setChanged();
        Level level = this.potEntity.getLevel();
        BlockPos pos = this.potEntity.getBlockPos();
        this.soil = BotanyPotHelper.findSoil(level, pos, this.potEntity, this.getSoilStack());
        this.crop = BotanyPotHelper.findCrop(level, pos, this.potEntity, this.getCropStack());
        this.requiredGrowthTime = BotanyPotHelper.getRequiredGrowthTicks(this.potEntity.getLevel(), this.potEntity.getBlockPos(), this.potEntity, this.crop, this.soil);
        int potLight = this.getPotEntity().getLightLevel();
        if (this.getPotEntity().getLevel() != null && (Integer)this.getPotEntity().getBlockState().getValue((Property)BlockStateProperties.LEVEL) != potLight) {
            this.getPotEntity().getLevel().setBlock(this.potEntity.getBlockPos(), (BlockState)this.getPotEntity().getBlockState().setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(potLight)), 3);
        }
        this.getPotEntity().markDirty();
    }

    @Nullable
    public RecipeHolder<Crop> getCrop() {
        return this.crop;
    }

    @Nullable
    public RecipeHolder<Soil> getSoil() {
        return this.soil;
    }

    public boolean canPlaceItem(int slotId, ItemStack toPlace) {
        Level level = this.potEntity.getLevel();
        BlockPos pos = this.potEntity.getBlockPos();
        if (slotId == 0 && this.getItem(slotId).isEmpty()) {
            return BotanyPotHelper.findSoil(level, pos, this.potEntity, toPlace) != null;
        }
        if (slotId == 1 && this.getItem(slotId).isEmpty()) {
            return BotanyPotHelper.findCrop(level, pos, this.potEntity, toPlace) != null;
        }
        return false;
    }

    public int[] getSlotsForFace(Direction side) {
        return side == Direction.DOWN ? STORAGE_SLOT : EMPTY_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slotId, ItemStack toInsert, Direction side) {
        return false;
    }

    public boolean canTakeItemThroughFace(int slotId, ItemStack toExtract, Direction side) {
        return side == Direction.DOWN && this.potEntity.isHopper() && slotId != 0 && slotId != 1;
    }

    public boolean stillValid(Player player) {
        if (this.potEntity == null || this.potEntity.isRemoved()) {
            return false;
        }
        BlockPos pos = this.potEntity.getBlockPos();
        return player.distanceToSqr((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f)) <= 24.0;
    }
}

