/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.inv;

import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.Constants;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotContainer;
import net.darkhax.botanypots.block.inv.SlotCropSeed;
import net.darkhax.botanypots.block.inv.SlotPotOutput;
import net.darkhax.botanypots.block.inv.SlotSoil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BotanyPotMenu
extends AbstractContainerMenu {
    private static final CachedSupplier<MenuType<?>> MENU_TYPE = CachedSupplier.cache(() -> (MenuType)BuiltInRegistries.MENU.get(new ResourceLocation("botanypots", "pot_menu")));
    private final BotanyPotContainer potInv;
    private final Inventory playerInv;

    public static BotanyPotMenu fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        BlockPos tilePos = (BlockPos)BookshelfByteBufs.BLOCK_POS.read(buf);
        BlockEntity blockEntity = inv.player.level().getBlockEntity(tilePos);
        if (blockEntity instanceof BlockEntityBotanyPot) {
            BlockEntityBotanyPot pot = (BlockEntityBotanyPot)blockEntity;
            return new BotanyPotMenu(windowId, (BotanyPotContainer)pot.getInventory(), inv);
        }
        Constants.LOG.error("Attempted to open botany pot at invalid position {}.", (Object)tilePos);
        throw new IllegalStateException("Attempted to open botany pot at invalid position " + tilePos);
    }

    public BotanyPotMenu(int id, BotanyPotContainer potInv, Inventory playerInv) {
        super((MenuType)MENU_TYPE.get(), id);
        this.potInv = potInv;
        this.playerInv = playerInv;
        int slotXOffset = this.isHopper() ? 44 : 80;
        this.addSlot(new SlotSoil((Container)potInv, 0, slotXOffset, 48, this.potInv.getPotEntity()::isValidSoil));
        this.addSlot(new SlotCropSeed((Container)potInv, 1, slotXOffset, 22, this.potInv.getPotEntity()::isValidSeed));
        if (this.isHopper()) {
            for (int potOutputY = 0; potOutputY < 3; ++potOutputY) {
                for (int potOutputX = 0; potOutputX < 4; ++potOutputX) {
                    int slotId = potOutputX + potOutputY * 4 + 2;
                    int slotX = 80 + potOutputX * 18;
                    int slotY = 17 + potOutputY * 18;
                    this.addSlot(new SlotPotOutput((Container)potInv, slotId, slotX, slotY));
                }
            }
        }
        for (int playerInvY = 0; playerInvY < 3; ++playerInvY) {
            for (int playerInvX = 0; playerInvX < 9; ++playerInvX) {
                this.addSlot(new Slot((Container)playerInv, playerInvX + playerInvY * 9 + 9, 8 + playerInvX * 18, 84 + playerInvY * 18));
            }
        }
        for (int hotbarX = 0; hotbarX < 9; ++hotbarX) {
            this.addSlot(new Slot((Container)playerInv, hotbarX, 8 + hotbarX * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int slotId) {
        BlockEntityBotanyPot pot = this.potInv.getPotEntity();
        Level level = pot.getLevel();
        BlockPos pos = pot.getBlockPos();
        Slot slot = (Slot)this.slots.get(slotId);
        int firstSlot = this.isHopper() ? 14 : 2;
        int lastSlot = this.isHopper() ? 50 : 38;
        ItemStack unmovedItems = ItemStack.EMPTY;
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            unmovedItems = slotStack.copy();
            if (this.isHopper() && slotId >= 2 && slotId <= 13) {
                if (!this.moveItemStackTo(slotStack, firstSlot, lastSlot, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, unmovedItems);
            } else if (slotId == 0 || slotId == 1) {
                if (!this.moveItemStackTo(slotStack, firstSlot, lastSlot, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (slotId >= firstSlot && slotId <= lastSlot) {
                Slot cropSlot;
                Slot soilSlot = (Slot)this.slots.get(0);
                if (!soilSlot.hasItem() && BotanyPotHelper.findSoil(level, pos, pot, slotStack) != null) {
                    soilSlot.set(slotStack.split(1));
                    slot.set(slotStack);
                    if (slotStack.isEmpty()) {
                        return ItemStack.EMPTY;
                    }
                }
                if (!(cropSlot = (Slot)this.slots.get(1)).hasItem() && BotanyPotHelper.findCrop(level, pos, pot, slotStack) != null) {
                    cropSlot.set(slotStack.split(1));
                    slot.set(slotStack);
                    if (slotStack.isEmpty()) {
                        return ItemStack.EMPTY;
                    }
                }
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == unmovedItems.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return unmovedItems;
    }

    public boolean isHopper() {
        return this.potInv.getPotEntity().isHopper();
    }

    public boolean stillValid(Player player) {
        return this.potInv.stillValid(player);
    }

    public BotanyPotContainer getPotInventory() {
        return this.potInv;
    }
}

