/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.inv;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotMenu;
import net.darkhax.botanypots.block.inv.SlotCropSeed;
import net.darkhax.botanypots.block.inv.SlotSoil;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class BotanyPotScreen
extends AbstractContainerScreen<BotanyPotMenu> {
    private static final NumberFormat MULTIPLIER_FORMAT = new DecimalFormat("##.##");
    private static final Component NEW_LINE = Component.literal((String)"");
    private static final Component TOOLTIP_INVALID_SOIL = Component.translatable((String)"tooltip.botanypots.invalid_soil").withStyle(ChatFormatting.RED);
    private static final Component TOOLTIP_INVALID_CROP = Component.translatable((String)"tooltip.botanypots.invalid_seed").withStyle(ChatFormatting.RED);
    private static final Component TOOLTIP_INCORRECT_SOIL = Component.translatable((String)"tooltip.botanypots.incorrect_soil").withStyle(ChatFormatting.RED);
    private static final Component TOOLTIP_INCORRECT_SEED = Component.translatable((String)"tooltip.botanypots.incorrect_seed").withStyle(ChatFormatting.RED);
    private static final Component TOOLTIP_MISSING_SOIL = Component.translatable((String)"tooltip.botanypots.missing_soil").withStyle(ChatFormatting.RED);
    private static final Component TOOLTIP_MISSING_SEED = Component.translatable((String)"tooltip.botanypots.missing_seed").withStyle(ChatFormatting.RED);
    private static final Component TOOLTIP_SOIL_ITEM = Component.translatable((String)"tooltip.botanypots.soil_item").withStyle(ChatFormatting.GREEN);
    private static final Component TOOLTIP_SEED_ITEM = Component.translatable((String)"tooltip.botanypots.seed_item").withStyle(ChatFormatting.GREEN);
    private static final ResourceLocation RECIPE_BUTTON_LOCATION = new ResourceLocation("textures/gui/recipe_button.png");
    private final ResourceLocation backgroundTexture;

    public BotanyPotScreen(BotanyPotMenu menu, Inventory playerInv, Component name) {
        super((AbstractContainerMenu)menu, playerInv, name);
        this.backgroundTexture = new ResourceLocation("botanypots", "textures/gui/container/" + (menu.isHopper() ? "hopper_botany_pot_gui.png" : "botany_pot_gui.png"));
    }

    public void init() {
        super.init();
        int recipeOffset = this.leftPos + (((BotanyPotMenu)this.menu).isHopper() ? 13 : 33);
    }

    protected void renderBg(GuiGraphics graphics, float v, int i, int i1) {
        graphics.blit(this.backgroundTexture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float tickDelta) {
        this.renderBackground(graphics, mouseX, mouseY, tickDelta);
        super.render(graphics, mouseX, mouseY, tickDelta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack stack) {
        List tooltips = super.getTooltipFromContainerItem(stack);
        if (this.minecraft != null) {
            boolean isAdvanced = this.minecraft.options.advancedItemTooltips;
            BlockEntityBotanyPot pot = ((BotanyPotMenu)this.menu).getPotInventory().getPotEntity();
            Level level = pot.getLevel();
            BlockPos pos = pot.getBlockPos();
            Slot slot = this.hoveredSlot;
            if (slot instanceof SlotSoil) {
                SlotSoil soilSlot = (SlotSoil)slot;
                if (!pot.isValidSoil(stack)) {
                    tooltips.add(TOOLTIP_INVALID_SOIL);
                } else {
                    Soil soil;
                    soilRecipe = BotanyPotHelper.findSoil(level, pos, pot, stack);
                    if (soilRecipe != null && (soil = (Soil)soilRecipe.value()) != null) {
                        if (pot.getCrop() == null) {
                            tooltips.add(TOOLTIP_MISSING_SEED);
                        } else if (!BotanyPotHelper.canCropGrow(level, pos, pot, soil, pot.getCrop())) {
                            tooltips.add(TOOLTIP_INCORRECT_SOIL);
                        } else {
                            float growthModifier = soil.getGrowthModifier(level, pos, pot, pot.getCrop());
                            MutableComponent multiplier = Component.literal((String)MULTIPLIER_FORMAT.format(growthModifier)).withStyle(growthModifier > 1.0f ? ChatFormatting.GREEN : (growthModifier < 1.0f ? ChatFormatting.RED : ChatFormatting.GRAY));
                            tooltips.add(Component.translatable((String)"tooltip.botanypots.soil_modifier", (Object[])new Object[]{multiplier}).withStyle(ChatFormatting.GRAY));
                        }
                    }
                }
            } else {
                soilRecipe = this.hoveredSlot;
                if (soilRecipe instanceof SlotCropSeed) {
                    Crop crop;
                    RecipeHolder<Crop> cropRecipe;
                    SlotCropSeed seedSlot = (SlotCropSeed)soilRecipe;
                    if (!pot.isValidSeed(stack)) {
                        tooltips.add(TOOLTIP_INVALID_CROP);
                    }
                    if ((cropRecipe = BotanyPotHelper.findCrop(level, pos, pot, stack)) != null && (crop = (Crop)cropRecipe.value()) != null) {
                        if (pot.getSoil() == null) {
                            tooltips.add(TOOLTIP_MISSING_SOIL);
                        } else if (!BotanyPotHelper.canCropGrow(level, pos, pot, pot.getSoil(), crop)) {
                            tooltips.add(TOOLTIP_INCORRECT_SEED);
                        }
                    }
                } else {
                    RecipeHolder<Crop> hoveredCrop;
                    RecipeHolder<Soil> hoverSoil = BotanyPotHelper.findSoil(level, pos, pot, stack);
                    if (hoverSoil != null) {
                        tooltips.add(TOOLTIP_SOIL_ITEM);
                        if (isAdvanced) {
                            tooltips.add(Component.translatable((String)"tooltip.botanypots.soil_id", (Object[])new Object[]{hoverSoil.id().toString()}).withStyle(ChatFormatting.GRAY));
                        }
                    }
                    if ((hoveredCrop = BotanyPotHelper.findCrop(level, pos, pot, stack)) != null) {
                        tooltips.add(TOOLTIP_SEED_ITEM);
                        if (isAdvanced) {
                            tooltips.add(Component.translatable((String)"tooltip.botanypots.crop_id", (Object[])new Object[]{hoveredCrop.id().toString()}).withStyle(ChatFormatting.GRAY));
                        }
                    }
                }
            }
        }
        return tooltips;
    }
}

