/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate.math;

import com.mojang.math.Axis;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.api.data.bytebuf.ByteBufHelper;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.api.data.codecs.CodecHelper;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public enum AxisAlignedRotation {
    X_0(RotationAxis.X, 0),
    X_90(RotationAxis.X, 1),
    X_180(RotationAxis.X, 2),
    X_270(RotationAxis.X, 3),
    Y_0(RotationAxis.Y, 0),
    Y_90(RotationAxis.Y, 1),
    Y_180(RotationAxis.Y, 2),
    Y_270(RotationAxis.Y, 3),
    Z_0(RotationAxis.Z, 0),
    Z_90(RotationAxis.Z, 1),
    Z_180(RotationAxis.Z, 2),
    Z_270(RotationAxis.Z, 3);

    public static final CodecHelper<AxisAlignedRotation> CODEC;
    public static final ByteBufHelper<AxisAlignedRotation> BUFFER;
    public final Quaternionf rotation;
    public final Vector3f offset;

    private AxisAlignedRotation(RotationAxis axis, int amount) {
        if (amount < 0 || amount > 3) {
            throw new IllegalArgumentException("Rotation amount " + amount + " is out of bounds. Must be 0-3. 0 = 0 degrees. 1 = 90 degrees. 2 = 180 degrees. 3 = 270 degrees.");
        }
        this.rotation = axis.quaternions[amount];
        this.offset = axis.offsets[amount];
    }

    static {
        CODEC = new CodecHelper(BookshelfCodecs.enumerable(AxisAlignedRotation.class), (Object[])new AxisAlignedRotation[0]);
        BUFFER = BookshelfByteBufs.enumerable(AxisAlignedRotation.class);
    }

    public static enum RotationAxis {
        X(Axis.XP, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, -1.0f, -1.0f), new Vector3f(0.0f, -1.0f, 0.0f)),
        Y(Axis.YP, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, -1.0f)),
        Z(Axis.ZP, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f));

        private final Quaternionf[] quaternions;
        private final Vector3f[] offsets;

        private RotationAxis(Axis axisVect, Vector3f offsetA, Vector3f offsetB, Vector3f offsetC, Vector3f offsetD) {
            this.quaternions = new Quaternionf[]{axisVect.rotationDegrees(0.0f), axisVect.rotationDegrees(90.0f), axisVect.rotationDegrees(180.0f), axisVect.rotationDegrees(270.0f)};
            this.offsets = new Vector3f[]{offsetA, offsetB, offsetC, offsetD};
        }
    }
}

