/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate.types;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.darkhax.botanypots.Constants;
import net.darkhax.botanypots.data.displaystate.DisplayTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DisplayState {
    public abstract DisplayTypes.DisplayType<?> getType();

    public static Optional<Map<String, String>> encodeProperties(BlockState state) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (Map.Entry entry : state.getValues().entrySet()) {
            propertyMap.put(((Property)entry.getKey()).getName(), ((Property)entry.getKey()).getName((Comparable)entry.getValue()));
        }
        return Optional.ofNullable(propertyMap.isEmpty() ? null : propertyMap);
    }

    public static BlockState decodeBlockState(Block block, Optional<Map<String, String>> properties) {
        BlockState state = block.defaultBlockState();
        if (properties.isPresent()) {
            StateDefinition definition = block.getStateDefinition();
            for (Map.Entry<String, String> entry : properties.get().entrySet()) {
                Property property = definition.getProperty(entry.getKey());
                if (property != null) {
                    Optional value = property.getValue(entry.getValue());
                    if (value.isPresent()) {
                        try {
                            state = (BlockState)state.setValue(property, (Comparable)value.get());
                            continue;
                        }
                        catch (Exception e) {
                            Constants.LOG.error("Failed to update state for block {} with valid value {}={}. The mod that adds this block may have a serious issue.", new Object[]{BuiltInRegistries.BLOCK.getKey((Object)block), entry.getKey(), entry.getValue()});
                            return state;
                        }
                    }
                    Constants.LOG.error("\"{}\" is not a valid value for property \"{}\" on block \"{}\". Available values: {}", new Object[]{entry.getValue(), property.getName(), BuiltInRegistries.BLOCK.getKey((Object)block), property.getAllValues().map(propVal -> property.getName(propVal.value())).collect(Collectors.joining())});
                    return state;
                }
                Constants.LOG.error("The property \"{}\" is not valid for block \"{}\". Available properties: {}", new Object[]{entry.getKey(), BuiltInRegistries.BLOCK.getKey((Object)block), definition.getProperties().stream().map(Property::getName).collect(Collectors.joining())});
                return state;
            }
        }
        return state;
    }
}

