/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.fertilizer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.botanypots.data.recipes.fertilizer.BasicFertilizer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public final class BasicFertilizerSerializer
implements RecipeSerializer<BasicFertilizer> {
    public static final RecipeSerializer<?> SERIALIZER = new BasicFertilizerSerializer();
    private static final Codec<BasicFertilizer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(BasicFertilizer::getIngredient), (App)Ingredient.CODEC_NONEMPTY.optionalFieldOf("crop_ingredient").forGetter(BasicFertilizer::getCropIngredient), (App)Ingredient.CODEC_NONEMPTY.optionalFieldOf("soil_ingredient").forGetter(BasicFertilizer::getSoilIngredient), (App)Codec.INT.fieldOf("min_growth").forGetter(BasicFertilizer::getMinTicks), (App)Codec.INT.fieldOf("max_growth").forGetter(BasicFertilizer::getMaxTicks)).apply((Applicative)instance, BasicFertilizer::new));

    public Codec<BasicFertilizer> codec() {
        return CODEC;
    }

    public BasicFertilizer fromNetwork(FriendlyByteBuf buffer) {
        Ingredient ingredient = (Ingredient)BookshelfByteBufs.INGREDIENT.read(buffer);
        Optional cropIngredient = BookshelfByteBufs.INGREDIENT.readOptional(buffer);
        Optional soilIngredient = BookshelfByteBufs.INGREDIENT.readOptional(buffer);
        int minTicks = (Integer)BookshelfByteBufs.INT.read(buffer);
        int maxTicks = (Integer)BookshelfByteBufs.INT.read(buffer);
        return new BasicFertilizer(ingredient, cropIngredient, soilIngredient, minTicks, maxTicks);
    }

    public void toNetwork(FriendlyByteBuf buffer, BasicFertilizer toWrite) {
        BookshelfByteBufs.INGREDIENT.write(buffer, (Object)toWrite.ingredient);
        BookshelfByteBufs.INGREDIENT.writeOptional(buffer, toWrite.cropIngredient);
        BookshelfByteBufs.INGREDIENT.writeOptional(buffer, toWrite.soilIngredient);
        BookshelfByteBufs.INT.write(buffer, (Object)toWrite.minTicks);
        BookshelfByteBufs.INT.write(buffer, (Object)toWrite.maxTicks);
    }
}

