/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.potinteraction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.botanypots.data.recipes.potinteraction.BasicPotInteraction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public final class BasicPotInteractionSerializer
implements RecipeSerializer<BasicPotInteraction> {
    public static final RecipeSerializer<?> INSTANCE = new BasicPotInteractionSerializer();
    public static final Codec<BasicPotInteraction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BookshelfCodecs.INGREDIENT.get("held_ingredient", BasicPotInteraction::getHeldTest), (App)BookshelfCodecs.BOOLEAN.get("damage_held", BasicPotInteraction::isDamageHeld, (Object)true), (App)BookshelfCodecs.INGREDIENT.getOptional("soil_ingredient", BasicPotInteraction::getSoilTest), (App)BookshelfCodecs.INGREDIENT.getOptional("seed_ingredient", BasicPotInteraction::getSeedTest), (App)BookshelfCodecs.ITEM_STACK_FLEXIBLE.getOptional("soil_output", BasicPotInteraction::getNewSoilStack), (App)BookshelfCodecs.ITEM_STACK_FLEXIBLE.getOptional("seed_output", BasicPotInteraction::getNewSeedStack), (App)BookshelfCodecs.SOUND.getOptional("sound", BasicPotInteraction::getSound), (App)BookshelfCodecs.ITEM_STACK_FLEXIBLE.getList("drops", BasicPotInteraction::getExtraDrops, new ArrayList())).apply((Applicative)instance, BasicPotInteraction::new));

    public Codec<BasicPotInteraction> codec() {
        return CODEC;
    }

    public BasicPotInteraction fromNetwork(FriendlyByteBuf buffer) {
        Ingredient heldTest = (Ingredient)BookshelfByteBufs.INGREDIENT.read(buffer);
        boolean damageHeld = (Boolean)BookshelfByteBufs.BOOLEAN.read(buffer);
        Optional soilTest = BookshelfByteBufs.INGREDIENT.readOptional(buffer);
        Optional seedTest = BookshelfByteBufs.INGREDIENT.readOptional(buffer);
        Optional soilOutput = BookshelfByteBufs.ITEM_STACK.readOptional(buffer);
        Optional seedOutput = BookshelfByteBufs.ITEM_STACK.readOptional(buffer);
        Optional sound = BookshelfByteBufs.SOUND.readOptional(buffer);
        List extraDrops = BookshelfByteBufs.ITEM_STACK.readList(buffer);
        return new BasicPotInteraction(heldTest, damageHeld, soilTest, seedTest, soilOutput, seedOutput, sound, extraDrops);
    }

    public void toNetwork(FriendlyByteBuf buffer, BasicPotInteraction toWrite) {
        BookshelfByteBufs.INGREDIENT.write(buffer, (Object)toWrite.heldTest);
        BookshelfByteBufs.BOOLEAN.write(buffer, (Object)toWrite.damageHeld);
        BookshelfByteBufs.INGREDIENT.writeOptional(buffer, toWrite.soilTest);
        BookshelfByteBufs.INGREDIENT.writeOptional(buffer, toWrite.seedTest);
        BookshelfByteBufs.ITEM_STACK.writeOptional(buffer, toWrite.newSoilStack);
        BookshelfByteBufs.ITEM_STACK.writeOptional(buffer, toWrite.newSeedStack);
        BookshelfByteBufs.SOUND.writeOptional(buffer, toWrite.sound);
        BookshelfByteBufs.ITEM_STACK.writeList(buffer, toWrite.extraDrops);
    }
}

