/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.soil;

import java.util.Set;
import javax.annotation.Nullable;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.displaystate.types.DisplayState;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class BasicSoil
extends Soil {
    protected Ingredient ingredient;
    protected DisplayState displayState;
    protected float growthModifier;
    protected Set<String> categories;
    protected int lightLevel;

    public BasicSoil(Ingredient ingredient, DisplayState renderState, float growthModifier, Set<String> categories, int lightLevel) {
        this.ingredient = ingredient;
        this.displayState = renderState;
        this.growthModifier = growthModifier;
        this.categories = categories;
        this.lightLevel = lightLevel;
    }

    @Override
    public boolean matchesLookup(Level level, BlockPos pos, BlockEntityBotanyPot pot, ItemStack placedStack) {
        return this.ingredient.test(placedStack);
    }

    @Override
    public float getGrowthModifier(Level level, BlockPos pos, BlockEntityBotanyPot pot, @Nullable Crop crop) {
        return this.growthModifier;
    }

    @Override
    public int getLightLevel(Level level, BlockPos pos, BlockEntityBotanyPot pot) {
        return this.lightLevel;
    }

    @Override
    public boolean canGrowCrop(Level level, BlockPos pos, BlockEntityBotanyPot pot, Crop crop) {
        for (String soilCategory : this.getCategories(level, pos, pot)) {
            for (String cropCategory : crop.getCategories(level, pos, pot)) {
                if (!soilCategory.equalsIgnoreCase(cropCategory)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<String> getCategories(Level level, BlockPos pos, BlockEntityBotanyPot pot) {
        return this.categories;
    }

    @Override
    public DisplayState getDisplayState(Level level, BlockPos pos, BlockEntityBotanyPot pot) {
        return this.displayState;
    }

    @Override
    public RecipeType<?> getType() {
        return (RecipeType)BotanyPotHelper.SOIL_TYPE.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)BotanyPotHelper.SOIL_SERIALIZER.get();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public DisplayState getDisplayState() {
        return this.displayState;
    }

    public float getGrowthModifier() {
        return this.growthModifier;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }
}

