/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.soil;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.botanypots.data.displaystate.DisplayTypes;
import net.darkhax.botanypots.data.displaystate.types.DisplayState;
import net.darkhax.botanypots.data.recipes.soil.BasicSoil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public final class BasicSoilSerializer
implements RecipeSerializer<BasicSoil> {
    public static BasicSoilSerializer SERIALIZER = new BasicSoilSerializer();
    public static Codec<BasicSoil> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BookshelfCodecs.INGREDIENT_NONEMPTY.get("input", BasicSoil::getIngredient), (App)DisplayTypes.DISPLAY_STATE_CODEC.get("display", BasicSoil::getDisplayState), (App)BookshelfCodecs.FLOAT.get("growthModifier", BasicSoil::getGrowthModifier, (Object)Float.valueOf(1.0f)), (App)BookshelfCodecs.STRING.getSet("categories", BasicSoil::getCategories), (App)BookshelfCodecs.INT.get("lightLevel", BasicSoil::getLightLevel, (Object)0)).apply((Applicative)instance, BasicSoil::new));

    public Codec<BasicSoil> codec() {
        return CODEC;
    }

    public BasicSoil fromNetwork(FriendlyByteBuf buffer) {
        Ingredient ingredient = (Ingredient)BookshelfByteBufs.INGREDIENT.read(buffer);
        DisplayState renderState = (DisplayState)DisplayTypes.DISPLAY_STATE_BUFFER.read(buffer);
        float growthModifier = ((Float)BookshelfByteBufs.FLOAT.read(buffer)).floatValue();
        HashSet<String> categories = new HashSet<String>(BookshelfByteBufs.STRING.readList(buffer));
        int lightLevel = (Integer)BookshelfByteBufs.INT.read(buffer);
        return new BasicSoil(ingredient, renderState, growthModifier, categories, lightLevel);
    }

    public void toNetwork(FriendlyByteBuf buffer, BasicSoil soilInfo) {
        BookshelfByteBufs.INGREDIENT.write(buffer, (Object)soilInfo.ingredient);
        DisplayTypes.DISPLAY_STATE_BUFFER.write(buffer, (Object)soilInfo.displayState);
        BookshelfByteBufs.FLOAT.write(buffer, (Object)Float.valueOf(soilInfo.growthModifier));
        BookshelfByteBufs.STRING.writeList(buffer, new ArrayList<String>(soilInfo.categories));
        BookshelfByteBufs.INT.write(buffer, (Object)soilInfo.lightLevel);
    }
}

