/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.addons.rei.ui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.addons.rei.REIPlugin;
import net.darkhax.botanypots.addons.rei.ui.CropDisplay;
import net.darkhax.botanypots.data.recipes.crop.BasicCrop;
import net.darkhax.botanypots.data.recipes.crop.HarvestEntry;
import net.darkhax.botanypots.data.recipes.soil.BasicSoil;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class BasicCropDisplay
extends BasicDisplay
implements CropDisplay {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");
    private final List<HarvestEntry> drops;
    private final int growthTime;
    private final float modifier;

    public static List<CropDisplay> getCropRecipes(BasicCrop crop, List<Soil> soils) {
        ArrayList<CropDisplay> info = new ArrayList<CropDisplay>();
        for (Soil soil : soils) {
            if (!(soil instanceof BasicSoil)) continue;
            BasicSoil basicSoil = (BasicSoil)soil;
            if (!crop.canGrowInSoil(null, null, null, soil)) continue;
            int ticks = BotanyPotHelper.getRequiredGrowthTicks(null, null, null, crop, soil);
            info.add(new BasicCropDisplay(crop.method_8114(), crop.getSeed(), basicSoil.getIngredient(), crop.getResults(), ticks, basicSoil.getGrowthModifier()));
        }
        return info;
    }

    public BasicCropDisplay(class_2960 id, class_1856 seed, class_1856 soil, List<HarvestEntry> drops, int growthTime, float modifier) {
        this(id, List.of(seed), List.of(soil), drops, growthTime, modifier);
    }

    public BasicCropDisplay(class_2960 id, List<class_1856> seeds, List<class_1856> soils, List<HarvestEntry> drops, int growthTime, float modifier) {
        super(List.of(BasicCropDisplay.reiIngredientFromIngredients(seeds), BasicCropDisplay.reiIngredientFromIngredients(soils)), BasicCropDisplay.reiIngredientsFromDrops(drops), Optional.ofNullable(id));
        this.drops = drops;
        this.growthTime = growthTime;
        this.modifier = modifier;
    }

    private static EntryIngredient reiIngredientFromIngredients(List<class_1856> seeds) {
        return EntryIngredients.ofItemStacks((Collection)CollectionUtils.flatMap(seeds, ingredient -> Arrays.asList(ingredient.method_8105())));
    }

    private static List<EntryIngredient> reiIngredientsFromDrops(List<HarvestEntry> drops) {
        return CollectionUtils.map(drops, entry -> EntryIngredients.of((class_1799)entry.getItem()));
    }

    public float getModifier() {
        return this.modifier;
    }

    public int getGrowthTime() {
        return this.growthTime;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return REIPlugin.CROP;
    }

    @Override
    public List<Widget> setupDisplay(Rectangle bounds) {
        List inputEntries = this.getInputEntries();
        List outputEntries = this.getOutputEntries();
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.x + 34, bounds.y + 16)).markInput().entries((Collection)((EntryIngredient)inputEntries.get(0)).map(stack -> stack.tooltip(this.getSeedTooltip()))));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.x + 34, bounds.y + 34)).markInput().entries((Collection)((EntryIngredient)inputEntries.get(1)).map(stack -> stack.tooltip(this.getSoilTooltip()))));
        int dropCount = 0;
        for (int i = 0; i < 12; ++i) {
            Slot slot = Widgets.createSlot((Point)new Point(bounds.x + 73 + 18 * (dropCount % 4), bounds.y + 7 + 18 * (dropCount / 4))).markOutput();
            widgets.add((Widget)slot);
            if (i < outputEntries.size()) {
                class_2561[] dropTooltip = this.getDropTooltip(this.drops.get(dropCount));
                slot.entries((Collection)((EntryIngredient)outputEntries.get(i)).map(stack -> stack.tooltip(dropTooltip)));
            }
            ++dropCount;
        }
        return widgets;
    }

    private class_2561[] getSeedTooltip() {
        return new class_2561[]{class_2561.method_43469((String)"tooltip.botanypots.grow_time", (Object[])new Object[]{BasicCropDisplay.ticksToTime(this.growthTime)}).method_27692(class_124.field_1080)};
    }

    private class_2561[] getSoilTooltip() {
        return new class_2561[]{class_2561.method_43469((String)"tooltip.botanypots.modifier", (Object[])new Object[]{FORMAT.format(this.modifier)}).method_27692(class_124.field_1080)};
    }

    private class_2561[] getDropTooltip(HarvestEntry drops) {
        int rollMax;
        int rollMin = drops.getMinRolls();
        class_5250 rolls = rollMin == (rollMax = drops.getMaxRolls()) ? class_2561.method_43469((String)"tooltip.botanypots.rolls", (Object[])new Object[]{rollMin}).method_27692(class_124.field_1080) : class_2561.method_43469((String)"tooltip.botanypots.rollrange", (Object[])new Object[]{rollMin, rollMax}).method_27692(class_124.field_1080);
        return new class_2561[]{class_2561.method_43469((String)"tooltip.botanypots.chance", (Object[])new Object[]{FORMAT.format(drops.getChance() * 100.0f)}).method_27692(class_124.field_1080), rolls};
    }

    private static String ticksToTime(int ticks) {
        ticks = Math.abs(ticks);
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }
}

