/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.StringJoiner;
import java.util.function.Consumer;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.commands.BotanyPotsCommands;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2473;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_4863;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CommandDump {
    public static void build(LiteralArgumentBuilder<class_2168> parent) {
        LiteralArgumentBuilder cmd = class_2170.method_9247((String)"dump");
        cmd.then(class_2170.method_9247((String)"missing_crops").executes(MissingCrops::dump));
        parent.then((ArgumentBuilder)cmd);
    }

    private static class MissingCrops {
        private static final class_6862<class_1792> FORGE_SEEDS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("forge", "seeds"));
        private static final class_6862<class_1792> COMMON_SEEDS = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("c", "seeds"));

        private MissingCrops() {
        }

        private static int dump(CommandContext<class_2168> ctx) {
            HashSet<class_1792> missingSeedItems = new HashSet<class_1792>();
            class_1863 manager = ((class_2168)ctx.getSource()).method_9211().method_3772();
            block0: for (class_1792 item2 : class_7923.field_41178) {
                if (MissingCrops.isCrop(item2.method_7854(), manager) || MissingCrops.isSoil(item2.method_7854(), manager) || !(item2 instanceof class_1747)) continue;
                class_1747 itemBlock = (class_1747)item2;
                class_2248 placedBlock = itemBlock.method_7711();
                if (placedBlock instanceof class_2302 || placedBlock instanceof class_4863 || placedBlock instanceof class_2256 || placedBlock instanceof class_2473 || placedBlock instanceof class_2261) {
                    missingSeedItems.add(item2);
                    continue;
                }
                for (class_2769 property : placedBlock.method_9595().method_11659()) {
                    if (!property.method_11899().equalsIgnoreCase("age")) continue;
                    missingSeedItems.add(item2);
                    continue block0;
                }
            }
            Consumer<class_1792> tagProcessor = item -> {
                if (!MissingCrops.isCrop(item.method_7854(), manager)) {
                    missingSeedItems.add((class_1792)item);
                }
            };
            MissingCrops.processTag(FORGE_SEEDS, tagProcessor);
            MissingCrops.processTag(COMMON_SEEDS, tagProcessor);
            if (missingSeedItems.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43471((String)"commands.botanypots.dump.no_results")), false);
            } else {
                StringJoiner entries = new StringJoiner(System.lineSeparator());
                entries.add("Potential missing crop IDs");
                missingSeedItems.stream().sorted(MissingCrops::compareById).forEach(e -> entries.add(class_7923.field_41178.method_10221(e).toString()));
                ((class_2168)ctx.getSource()).method_9226(() -> BotanyPotsCommands.modMessage((class_2561)class_2561.method_43469((String)"commands.botanypots.dump.missing_crops", (Object[])new Object[]{class_2561.method_43470((String)Integer.toString(missingSeedItems.size())).method_27694(style -> style.method_10977(class_124.field_1061))}).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, entries.toString())))), false);
            }
            return 0;
        }

        private static void processTag(class_6862<class_1792> key, Consumer<class_1792> consumer) {
            class_7923.field_41178.method_40266(key).ifPresent(named -> named.forEach(entry -> consumer.accept((class_1792)entry.comp_349())));
        }

        private static boolean isCrop(class_1799 stack, class_1863 recipes) {
            for (Crop crop : recipes.method_30027((class_3956)BotanyPotHelper.CROP_TYPE.get())) {
                if (!crop.matchesLookup(null, null, null, stack)) continue;
                return true;
            }
            return false;
        }

        private static boolean isSoil(class_1799 stack, class_1863 recipes) {
            for (Soil soil : recipes.method_30027((class_3956)BotanyPotHelper.SOIL_TYPE.get())) {
                if (!soil.matchesLookup(null, null, null, stack)) continue;
                return true;
            }
            return false;
        }

        private static int compareById(class_1792 e1, class_1792 e2) {
            return class_7923.field_41178.method_10221((Object)e1).toString().compareTo(class_7923.field_41178.method_10221((Object)e2).toString());
        }
    }
}

