/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.crop;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.util.MathsHelper;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.displaystate.DisplayState;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.crop.HarvestEntry;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2960;

public class BasicCrop
extends Crop {
    protected class_1856 seed;
    protected Set<String> soilCategories;
    protected int growthTicks;
    protected List<HarvestEntry> results;
    protected List<DisplayState> displayStates;
    protected int lightLevel;

    public BasicCrop(class_2960 id, class_1856 seed, Set<String> soilCategories, int growthTicks, List<HarvestEntry> results, List<DisplayState> displayStates, int lightLevel) {
        super(id);
        this.seed = seed;
        this.soilCategories = soilCategories;
        this.growthTicks = growthTicks;
        this.results = results;
        this.displayStates = displayStates;
        this.lightLevel = lightLevel;
    }

    @Override
    public boolean matchesLookup(class_1937 level, class_2338 pos, BlockEntityBotanyPot pot, class_1799 placedStack) {
        Soil soil;
        if (pot != null && (soil = pot.getSoil()) != null && !BotanyPotHelper.canCropGrow(level, pos, pot, soil, this)) {
            return false;
        }
        return this.seed.method_8093(placedStack);
    }

    @Override
    public int getGrowthTicks(class_1937 level, class_2338 pos, BlockEntityBotanyPot pot, @Nullable Soil soil) {
        return this.growthTicks;
    }

    @Override
    public int getLightLevel(class_1937 level, class_2338 pos, BlockEntityBotanyPot pot) {
        return this.lightLevel;
    }

    @Override
    public boolean canGrowInSoil(class_1937 level, class_2338 pos, BlockEntityBotanyPot pot, Soil soil) {
        for (String soilCategory : soil.getCategories(level, pos, pot)) {
            for (String cropCategory : this.getCategories(level, pos, pot)) {
                if (!soilCategory.equalsIgnoreCase(cropCategory)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<String> getCategories(class_1937 level, class_2338 pos, BlockEntityBotanyPot pot) {
        return this.soilCategories;
    }

    @Override
    public List<DisplayState> getDisplayState(class_1937 level, class_2338 pos, BlockEntityBotanyPot pot) {
        return this.displayStates;
    }

    @Override
    public List<class_1799> generateDrops(Random rng, class_1937 level, class_2338 pos, BlockEntityBotanyPot pot) {
        class_2371 drops = class_2371.method_10211();
        for (HarvestEntry cropEntry : this.results) {
            int rolls;
            if (!(rng.nextFloat() <= cropEntry.getChance()) || (rolls = MathsHelper.nextIntInclusive((Random)rng, (int)cropEntry.getMinRolls(), (int)cropEntry.getMaxRolls())) <= 0) continue;
            for (int roll = 0; roll < rolls; ++roll) {
                drops.add((Object)cropEntry.getItem().method_7972());
            }
        }
        return drops;
    }

    public class_1865<?> method_8119() {
        return (class_1865)BotanyPotHelper.CROP_SERIALIZER.get();
    }

    public class_1856 getSeed() {
        return this.seed;
    }

    public Set<String> getSoilCategories() {
        return Collections.unmodifiableSet(this.soilCategories);
    }

    public int getGrowthTicks() {
        return this.growthTicks;
    }

    public List<HarvestEntry> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public List<DisplayState> getDisplayStates() {
        return Collections.unmodifiableList(this.displayStates);
    }

    public int getLightLevel() {
        return this.lightLevel;
    }
}

