/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.recipes.fertilizer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.data.recipes.fertilizer.BasicFertilizer;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public final class BasicFertilizerSerializer
implements class_1865<BasicFertilizer> {
    public static final class_1865<?> SERIALIZER = new BasicFertilizerSerializer();

    public BasicFertilizer fromJson(class_2960 id, JsonObject json) {
        class_1856 ingredient = (class_1856)Serializers.INGREDIENT.fromJSON(json, "ingredient");
        class_1856 cropIngredient = (class_1856)Serializers.INGREDIENT.fromJSONNullable(json, "crop_ingredient");
        class_1856 soilIngredient = (class_1856)Serializers.INGREDIENT.fromJSONNullable(json, "soil_ingredient");
        int minTicks = (Integer)Serializers.INT.fromJSON(json, "min_growth");
        int maxTicks = (Integer)Serializers.INT.fromJSON(json, "max_growth");
        if (minTicks < 0 || maxTicks < 0) {
            throw new JsonParseException("Growth ticks must be greater than 0! min=" + minTicks + " max=" + maxTicks);
        }
        if (minTicks > maxTicks) {
            throw new JsonParseException("Min growth ticks must not be greater than max ticks.  min=" + minTicks + " max=" + maxTicks);
        }
        return new BasicFertilizer(id, ingredient, cropIngredient, soilIngredient, minTicks, maxTicks);
    }

    public BasicFertilizer fromNetwork(class_2960 id, class_2540 buffer) {
        class_1856 ingredient = (class_1856)Serializers.INGREDIENT.fromByteBuf(buffer);
        class_1856 cropIngredient = (class_1856)Serializers.INGREDIENT.fromByteBufNullable(buffer);
        class_1856 soilIngredient = (class_1856)Serializers.INGREDIENT.fromByteBufNullable(buffer);
        int minTicks = (Integer)Serializers.INT.fromByteBuf(buffer);
        int maxTicks = (Integer)Serializers.INT.fromByteBuf(buffer);
        return new BasicFertilizer(id, ingredient, cropIngredient, soilIngredient, minTicks, maxTicks);
    }

    public void toNetwork(class_2540 buffer, BasicFertilizer toWrite) {
        Serializers.INGREDIENT.toByteBuf(buffer, (Object)toWrite.ingredient);
        Serializers.INGREDIENT.toByteBufNullable(buffer, (Object)toWrite.cropIngredient);
        Serializers.INGREDIENT.toByteBufNullable(buffer, (Object)toWrite.soilIngredient);
        Serializers.INT.toByteBuf(buffer, (Object)toWrite.minTicks);
        Serializers.INT.toByteBuf(buffer, (Object)toWrite.maxTicks);
    }
}

