/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.cereal.serial;

import com.terrano.cereal.CerealSpec;
import com.terrano.cereal.serial.DataBuffer;
import com.terrano.cereal.value.DataList;
import com.terrano.cereal.value.DataObject;
import com.terrano.cereal.value.DataValue;
import java.io.IOException;
import java.io.Reader;

public class DataReader
implements AutoCloseable {
    private static final char NONE = '\uffff';
    private final Reader reader;
    private final CerealSpec spec;
    private final DataBuffer buffer = new DataBuffer();
    private char c = (char)65535;

    public DataReader(Reader reader) {
        this(reader, CerealSpec.STANDARD);
    }

    public DataReader(Reader reader, CerealSpec spec) {
        this.reader = reader;
        this.spec = spec;
    }

    private boolean next() throws IOException {
        int i = this.reader.read();
        if (i == -1) {
            return false;
        }
        this.c = (char)i;
        return true;
    }

    private void skipSpace() throws IOException {
        while (Character.isWhitespace(this.c)) {
            if (this.next()) continue;
            throw new IOException("Unexpected end");
        }
    }

    public DataValue read() throws IOException {
        return this.next() ? this.readValue() : DataValue.NULL;
    }

    private DataValue readValue() throws IOException {
        this.skipSpace();
        if (this.c == '{' && this.next()) {
            return this.readObject("");
        }
        if (this.c == '[' && this.next()) {
            return this.readList();
        }
        Object value = this.readPrimitive();
        if (value instanceof String) {
            this.skipSpace();
            if (this.c == '{' && this.next()) {
                return this.readObject(value.toString());
            }
        }
        return DataValue.of(value);
    }

    private DataValue readObject(String type) throws IOException {
        DataObject data = new DataObject(type);
        while (true) {
            this.skipSpace();
            if (this.c == '}') {
                this.next();
                return data;
            }
            String key = this.readKey();
            DataValue value = this.readValue();
            data.add(key, value);
        }
    }

    private DataValue readList() throws IOException {
        DataList list = new DataList();
        while (true) {
            this.skipSpace();
            if (this.c == ']') {
                this.next();
                return list;
            }
            list.add(this.readValue());
        }
    }

    private String readKey() throws IOException {
        this.skipSpace();
        this.buffer.reset();
        this.buffer.append(this.c);
        while (this.next()) {
            if (!Character.isLetterOrDigit(this.c) && this.c != '_') {
                if (this.c == ':') {
                    this.next();
                }
                return this.buffer.toString();
            }
            this.buffer.append(this.c);
        }
        throw new IOException("Unexpected end: " + this.buffer.toString());
    }

    private Object readPrimitive() throws IOException {
        if (this.c == this.spec.escapeChar) {
            return this.readEscapedString();
        }
        this.buffer.reset();
        this.buffer.append(this.c);
        while (this.next()) {
            if (!Character.isLetterOrDigit(this.c) && this.c != '.' && this.c != '-' && this.c != '_') {
                return this.buffer.getValue();
            }
            this.buffer.append(this.c);
        }
        throw new IOException("Unexpected end of string: " + this.buffer.toString());
    }

    private String readEscapedString() throws IOException {
        this.buffer.reset();
        while (this.next()) {
            if (this.c == this.spec.escapeChar) {
                this.next();
                return this.buffer.toString();
            }
            this.buffer.append(this.c);
        }
        throw new IOException("Unexpected end of string: " + this.buffer.toString());
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }
}

