/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.cereal.spec;

import com.terrano.cereal.spec.Context;
import com.terrano.cereal.spec.DataSpec;
import com.terrano.cereal.spec.DefaultData;
import com.terrano.cereal.value.DataObject;
import com.terrano.cereal.value.DataValue;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SubSpec<T> {
    private final Class<T> superType;
    private final Map<Class<? extends T>, DataSpec<? extends T>> children = new ConcurrentHashMap<Class<? extends T>, DataSpec<? extends T>>();

    public SubSpec(Class<T> type) {
        this.superType = type;
    }

    public Class<T> getSuperType() {
        return this.superType;
    }

    public <V extends T> SubSpec<T> register(Class<V> type, DataSpec<V> spec) {
        this.children.put(type, spec);
        return this;
    }

    public T deserialize(DataObject data, Context context) {
        Iterator<DataSpec<T>> var3 = this.children.values().iterator();
        while (true) {
            if (!var3.hasNext()) {
                throw new RuntimeException("Unsupported data: " + String.valueOf(data));
            }
            DataSpec<T> spec = var3.next();
            if (!SubSpec.matches(data, spec)) continue;
            try {
                return spec.deserialize(data, context);
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public <V extends T> DataValue serialize(V value, Context context) {
        DataSpec<T> spec = this.children.get(value.getClass());
        if (spec == null) {
            throw new RuntimeException("Missing sub-spec for type: " + String.valueOf(value.getClass()));
        }
        return spec.serialize(value, context);
    }

    protected static boolean matches(DataObject object, DataSpec<?> spec) {
        DataValue defaultValue;
        Map.Entry<String, DefaultData> entry;
        DataValue value;
        Iterator<Map.Entry<String, DefaultData>> var2 = spec.getDefaults().entrySet().iterator();
        do {
            if (!var2.hasNext()) {
                return true;
            }
            entry = var2.next();
            if (object.has(entry.getKey())) continue;
            return false;
        } while ((value = object.get(entry.getKey())).matchesType(defaultValue = entry.getValue().getValue()));
        return false;
    }
}

