/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.concurrent;

import com.terrano.engine.concurrent.Resource;
import com.terrano.engine.concurrent.SimpleResource;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ThreadLocalResource<T>
extends ThreadLocal<Resource<T>> {
    private final Supplier<Resource<T>> supplier;

    private ThreadLocalResource(Supplier<Resource<T>> supplier) {
        this.supplier = supplier;
    }

    public T open() {
        Resource resource = (Resource)this.get();
        return resource.get();
    }

    public void close() {
        Resource resource = (Resource)this.get();
        resource.close();
    }

    @Override
    protected Resource<T> initialValue() {
        return this.supplier.get();
    }

    public static <T> ThreadLocalResource<T> withInitial(Supplier<T> supplier, Consumer<T> consumer) {
        return new ThreadLocalResource<T>(() -> new SimpleResource(supplier.get(), consumer));
    }
}

