/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.concurrent.cache;

import com.terrano.engine.concurrent.cache.ExpiringEntry;
import com.terrano.engine.concurrent.cache.SafeCloseable;
import com.terrano.engine.concurrent.task.LazyCallable;
import com.terrano.engine.concurrent.thread.ThreadPool;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.function.Function;

public class CacheEntry<T>
extends LazyCallable<T>
implements ExpiringEntry {
    private volatile long timestamp;
    private final Future<T> task;

    public CacheEntry(Future<T> task) {
        this.task = task;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public T get() {
        this.timestamp = System.currentTimeMillis();
        return super.get();
    }

    @Override
    public boolean isDone() {
        return this.task.isDone();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void close() {
        if (this.value instanceof SafeCloseable) {
            ((SafeCloseable)this.value).close();
        } else if (this.value instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.value).close();
            }
            catch (Exception var2) {
                var2.printStackTrace();
            }
        }
    }

    @Override
    protected T create() {
        if (this.task instanceof ForkJoinTask) {
            return (T)((ForkJoinTask)this.task).join();
        }
        try {
            return this.task.get();
        }
        catch (Throwable var2) {
            throw new RuntimeException(var2);
        }
    }

    @Override
    public <V> CacheEntry<V> then(ThreadPool executor, Function<T, V> function) {
        return CacheEntry.computeAsync(() -> function.apply(this.get()), executor);
    }

    public static <T> CacheEntry<T> supply(Future<T> task) {
        return new CacheEntry<T>(task);
    }

    public static <T> CacheEntry<T> computeAsync(Callable<T> callable, ThreadPool executor) {
        return new CacheEntry<T>(executor.submit(callable));
    }
}

