/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.filter;

import com.terrano.engine.cell.Cell;
import com.terrano.noise.util.NoiseUtil;

public interface Modifier {
    public float getValueModifier(float var1);

    default public float modify(Cell cell, float value) {
        float strengthModifier = 1.0f;
        float erosionModifier = cell.terrain.erosionModifier();
        if (erosionModifier != 1.0f) {
            float alpha = NoiseUtil.map(cell.terrainRegionEdge, 0.0f, 0.15f, 0.15f);
            strengthModifier = NoiseUtil.lerp(1.0f, erosionModifier, alpha);
        }
        if (cell.riverMask < 0.1f) {
            strengthModifier *= NoiseUtil.map(cell.riverMask, 0.002f, 0.1f, 0.098f);
        }
        return this.getValueModifier(cell.value) * strengthModifier * value;
    }

    default public Modifier invert() {
        return v -> 1.0f - this.getValueModifier(v);
    }

    public static Modifier range(final float minValue, final float maxValue) {
        return new Modifier(){
            private final float min;
            private final float max;
            private final float range;
            {
                this.min = minValue;
                this.max = maxValue;
                this.range = maxValue - minValue;
            }

            @Override
            public float getValueModifier(float value) {
                if (value > this.max) {
                    return 1.0f;
                }
                return value < this.min ? 0.0f : (value - this.min) / this.range;
            }
        };
    }
}

