/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.module;

import com.terrano.engine.cell.Cell;
import com.terrano.engine.cell.Populator;
import com.terrano.engine.module.Select;
import com.terrano.engine.world.terrain.Terrain;
import com.terrano.noise.Module;
import com.terrano.noise.func.Interpolation;
import com.terrano.noise.util.NoiseUtil;

public class Blender
extends Select
implements Populator {
    private final Populator lower;
    private final Populator upper;
    private final float blendLower;
    private final float blendUpper;
    private final float blendRange;
    private final float midpoint;
    private final float tagThreshold;

    public Blender(Module control, Populator lower, Populator upper, float min, float max, float split) {
        super(control);
        this.lower = lower;
        this.upper = upper;
        this.blendLower = min;
        this.blendUpper = max;
        this.blendRange = this.blendUpper - this.blendLower;
        this.tagThreshold = this.midpoint = this.blendLower + this.blendRange * split;
    }

    public Blender(Populator control, Populator lower, Populator upper, float min, float max, float split, float tagThreshold) {
        super(control);
        this.lower = lower;
        this.upper = upper;
        this.blendLower = min;
        this.blendUpper = max;
        this.blendRange = this.blendUpper - this.blendLower;
        this.midpoint = this.blendLower + this.blendRange * split;
        this.tagThreshold = tagThreshold;
    }

    @Override
    public void apply(Cell cell, float x, float y) {
        float select = this.getSelect(cell, x, y);
        if (select < this.blendLower) {
            this.lower.apply(cell, x, y);
        } else if (select > this.blendUpper) {
            this.upper.apply(cell, x, y);
        } else {
            float alpha = Interpolation.LINEAR.apply((select - this.blendLower) / this.blendRange);
            this.lower.apply(cell, x, y);
            float lowerVal = cell.value;
            Terrain lowerType = cell.terrain;
            this.upper.apply(cell, x, y);
            float upperVal = cell.value;
            cell.value = NoiseUtil.lerp(lowerVal, upperVal, alpha);
            if (select < this.midpoint) {
                cell.terrain = lowerType;
            }
        }
    }
}

