/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.render;

import com.terrano.engine.concurrent.task.LazyCallable;
import com.terrano.engine.concurrent.thread.ThreadPool;
import com.terrano.engine.concurrent.thread.ThreadPools;
import com.terrano.engine.render.RegionRenderer;
import com.terrano.engine.render.RenderAPI;
import com.terrano.engine.render.RenderRegion;
import com.terrano.engine.render.RenderSettings;
import com.terrano.engine.tile.Size;
import com.terrano.engine.tile.Tile;
import com.terrano.engine.tile.api.TileProvider;
import com.terrano.engine.tile.gen.TileGenerator;
import com.terrano.engine.util.RollingGrid;
import com.terrano.engine.util.pos.PosIterator;
import java.util.Iterator;

public class RenderWorld2
implements RollingGrid.Generator<RegionHolder> {
    private final int factor;
    private final Size regionSize;
    private final TileProvider cache;
    private final TileGenerator generator;
    private final RenderAPI context;
    private final RegionRenderer renderer;
    private final RollingGrid<RegionHolder> world;
    private final ThreadPool threadPool = ThreadPools.createDefault();
    private boolean first = true;

    public RenderWorld2(TileGenerator generator, RenderAPI context, RenderSettings settings, int regionCount, int regionSize) {
        this.context = context;
        this.factor = regionSize;
        this.generator = generator;
        this.cache = generator.cached();
        this.regionSize = Size.blocks(regionSize, 0);
        this.renderer = new RegionRenderer(context, settings);
        this.world = new RollingGrid<RegionHolder>(regionCount, RegionHolder[]::new, this);
    }

    public boolean isBusy() {
        RegionHolder h;
        Iterator<RegionHolder> var1 = this.world.getIterator().iterator();
        do {
            if (var1.hasNext()) continue;
            return false;
        } while ((h = var1.next()) == null || h.region.isDone());
        return true;
    }

    public int getResolution() {
        return this.regionSize.total * this.world.getSize();
    }

    public int blockToRegion(int value) {
        return value >> this.factor;
    }

    public void init(int centerX, int centerZ) {
        this.renderer.getSettings().zoom = 1.0f;
        this.renderer.getSettings().resolution = this.regionSize.total;
        PosIterator iterator = PosIterator.area(0, 0, this.world.getSize(), this.world.getSize());
        while (iterator.next()) {
            RegionHolder holder = this.generate(iterator.x(), iterator.z());
            this.world.set(iterator.x(), iterator.z(), holder);
        }
    }

    public void move(int centerX, int centerZ) {
        if (this.first) {
            this.first = false;
            this.init(centerX, centerZ);
        } else {
            this.renderer.getSettings().zoom = 1.0f;
            this.renderer.getSettings().resolution = this.regionSize.total;
            this.world.move(centerX, centerZ);
        }
    }

    public void render() {
        int resolution = this.regionSize.total;
        float w = (float)this.renderer.getSettings().width * 1.0f / (float)(resolution - 1);
        float h = (float)this.renderer.getSettings().width * 1.0f / (float)(resolution - 1);
        float offsetX = (float)(this.world.getSize() * this.regionSize.size) * w / 2.0f;
        float offsetZ = (float)(this.world.getSize() * this.regionSize.size) * h / 2.0f;
        this.context.pushMatrix();
        this.context.translate(-offsetX, -offsetZ, 1000.0f);
        PosIterator iterator = PosIterator.area(0, 0, this.world.getSize(), this.world.getSize());
        while (iterator.next()) {
            RegionHolder holder = this.world.get(iterator.x(), iterator.z());
            if (holder == null || !holder.region.isDone()) continue;
            int relX = iterator.x();
            int relZ = iterator.z();
            float startX = (float)(relX * this.regionSize.size) * w;
            float startZ = (float)(relZ * this.regionSize.size) * h;
            RenderRegion region = holder.region.get();
            this.context.pushMatrix();
            this.context.translate(startX, startZ, 0.0f);
            region.getMesh().draw();
            this.context.popMatrix();
        }
        this.context.popMatrix();
    }

    @Override
    public RegionHolder generate(int x, int z) {
        LazyCallable<Tile> tileCallable = this.generator.getTile(x, z);
        LazyCallable<RenderRegion> renderCallable = tileCallable.then(this.threadPool, tile -> this.renderer.render((Tile)tile));
        return new RegionHolder(renderCallable);
    }

    public static class RegionHolder {
        private final LazyCallable<RenderRegion> region;

        private RegionHolder(LazyCallable<RenderRegion> region) {
            this.region = region;
        }

        RegionHolder(LazyCallable<RenderRegion> x0, Object x1) {
            this(x0);
        }
    }
}

