/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.util;

import com.terrano.engine.util.pos.PosIterator;
import com.terrano.noise.util.NoiseUtil;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.function.IntFunction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class RollingGrid<T> {
    private final int size;
    private final int half;
    private final T[] grid;
    private final Generator<T> generator;
    private int startX = 0;
    private int startZ = 0;

    public RollingGrid(int size, IntFunction<T[]> constructor, Generator<T> generator) {
        this.size = size;
        this.half = size / 2;
        this.generator = generator;
        this.grid = constructor.apply(size * size);
    }

    public Iterable<T> getIterator() {
        return Arrays.asList(this.grid);
    }

    public PosIterator iterator() {
        return PosIterator.area(this.startX, this.startZ, this.size, this.size);
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartZ() {
        return this.startZ;
    }

    public int getSize() {
        return this.size;
    }

    public void setCenter(int x, int z) {
        this.setCenter(x - this.half, z - this.half, true);
    }

    public void setCenter(int x, int z, boolean update) {
        this.setPos(x - this.half, z - this.half, update);
    }

    public void setPos(int x, int z) {
        this.setPos(x, z, true);
    }

    public void setPos(int x, int z, boolean update) {
        if (update) {
            int deltaX = x - this.startX;
            int deltaZ = z - this.startZ;
            this.move(deltaX, deltaZ);
        } else {
            this.startX = x;
            this.startZ = z;
        }
    }

    public void move(int x, int z) {
        int index;
        int dx;
        int dz;
        int pz;
        int maxZ;
        int minZ;
        if (x != 0) {
            minZ = x < 0 ? this.startX + x : this.startX + this.size - x + 1;
            maxZ = minZ + Math.abs(x);
            for (pz = minZ; pz < maxZ; ++pz) {
                dz = this.wrap(pz);
                for (dx = 0; dx < this.size; ++dx) {
                    index = this.index(dz, this.wrap(this.startZ + dx));
                    this.grid[index] = this.generator.generate(pz, this.startZ + dx);
                }
            }
        }
        if (z != 0) {
            minZ = z < 0 ? this.startZ + z : this.startZ + this.size - z + 1;
            maxZ = minZ + Math.abs(z);
            for (pz = minZ; pz < maxZ; ++pz) {
                dz = this.wrap(pz);
                for (dx = 0; dx < this.size; ++dx) {
                    index = this.index(this.wrap(this.startX + dx), dz);
                    this.grid[index] = this.generator.generate(this.startX + dx, pz);
                }
            }
        }
        this.startX += x;
        this.startZ += z;
    }

    public T get(int x, int z) {
        int mx = this.wrap(x += this.startX);
        int mz = this.wrap(z += this.startZ);
        return this.grid[this.index(mx, mz)];
    }

    public void set(int x, int z, T value) {
        int mx = this.wrap(x += this.startX);
        int mz = this.wrap(z += this.startZ);
        this.grid[this.index((int)mx, (int)mz)] = value;
    }

    private int index(int x, int z) {
        return z * this.size + x;
    }

    private int wrap(int value) {
        return (value % this.size + this.size) % this.size;
    }

    public static void main(String[] args) {
        final RollingGrid<Chunk> grid = RollingGrid.createGrid(32);
        final JLabel label = new JLabel();
        label.setIcon(new ImageIcon(RollingGrid.render(0, 0, grid)));
        label.setFocusable(true);
        label.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case 'a': {
                        grid.move(-1, 0);
                        label.setIcon(new ImageIcon(RollingGrid.render(0, 0, grid)));
                        label.repaint();
                        break;
                    }
                    case 'd': {
                        grid.move(1, 0);
                        label.setIcon(new ImageIcon(RollingGrid.render(0, 0, grid)));
                        label.repaint();
                        break;
                    }
                    case 's': {
                        grid.move(0, 1);
                        label.setIcon(new ImageIcon(RollingGrid.render(0, 0, grid)));
                        label.repaint();
                        break;
                    }
                    case 'w': {
                        grid.move(0, -1);
                        label.setIcon(new ImageIcon(RollingGrid.render(0, 0, grid)));
                        label.repaint();
                    }
                }
            }
        });
        JFrame frame = new JFrame();
        frame.add(label);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private static RollingGrid<Chunk> createGrid(int size) {
        RollingGrid<Chunk> grid = new RollingGrid<Chunk>(size, Chunk[]::new, Chunk::new);
        PosIterator iterator = PosIterator.area(0, 0, size, size);
        while (iterator.next()) {
            int x = iterator.x();
            int z = iterator.z();
            grid.set(x, z, new Chunk(x, z));
        }
        return grid;
    }

    /*
     * Unable to fully structure code
     */
    private static BufferedImage render(int x, int z, RollingGrid<Chunk> grid) {
        size = grid.size << 4;
        image = new BufferedImage(size, size, 1);
        chunkIterator = PosIterator.area(0, 0, grid.size, grid.size);
        block0: while (true) {
            if (!chunkIterator.next()) {
                return image;
            }
            chunkX = x + chunkIterator.x();
            chunk = grid.get(chunkX, chunkZ = z + chunkIterator.z());
            if (chunk == null) continue;
            pixel = PosIterator.area(chunkIterator.x() << 4, chunkIterator.z() << 4, 16, 16);
            while (true) {
                if (pixel.next()) ** break;
                continue block0;
                image.setRGB(pixel.x(), pixel.z(), chunk.color.getRGB());
            }
            break;
        }
    }

    public static interface Generator<T> {
        public T generate(int var1, int var2);
    }

    private static class Chunk {
        private final Color color;

        public Chunk() {
            this.color = Color.BLACK;
        }

        public Chunk(int x, int z) {
            this.color = new Color(NoiseUtil.hash(x, z));
        }
    }
}

