/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.world;

import com.terrano.engine.Seed;
import com.terrano.engine.concurrent.task.LazySupplier;
import com.terrano.engine.concurrent.thread.ThreadPools;
import com.terrano.engine.settings.Settings;
import com.terrano.engine.tile.api.TileProvider;
import com.terrano.engine.tile.gen.TileGenerator;
import com.terrano.engine.world.WorldGeneratorFactory;
import com.terrano.engine.world.heightmap.Levels;
import com.terrano.engine.world.terrain.provider.StandardTerrainProvider;
import com.terrano.engine.world.terrain.provider.TerrainProviderFactory;
import java.util.function.Function;

public class GeneratorContext {
    public final Seed seed;
    public final Levels levels;
    public final Settings settings;
    public final LazySupplier<TileProvider> cache;
    public final TerrainProviderFactory terrainFactory;
    public final LazySupplier<WorldGeneratorFactory> worldGenerator;

    public GeneratorContext(Settings settings) {
        this(settings, StandardTerrainProvider::new, GeneratorContext::createCache);
    }

    public <V> LazySupplier<V> then(Function<GeneratorContext, V> function) {
        return LazySupplier.factory(this.copy(), function);
    }

    public <T extends Settings> GeneratorContext(T settings, TerrainProviderFactory terrainFactory, Function<WorldGeneratorFactory, TileProvider> cache) {
        this.settings = settings;
        this.seed = new Seed(settings.world.seed);
        this.levels = new Levels(settings.world);
        this.terrainFactory = terrainFactory;
        this.worldGenerator = this.createFactory(this);
        this.cache = LazySupplier.supplied(this.worldGenerator, cache);
    }

    protected GeneratorContext(GeneratorContext src) {
        this(src, 0);
    }

    protected GeneratorContext(GeneratorContext src, int seedOffset) {
        this.seed = src.seed.offset(seedOffset);
        this.cache = src.cache;
        this.levels = src.levels;
        this.settings = src.settings;
        this.terrainFactory = src.terrainFactory;
        this.worldGenerator = src.worldGenerator;
    }

    public GeneratorContext copy() {
        return new GeneratorContext(this);
    }

    public GeneratorContext split(int offset) {
        return new GeneratorContext(this, offset);
    }

    public Seed seed() {
        return this.seed.split();
    }

    public Seed seed(int offset) {
        return this.seed.offset(offset);
    }

    protected LazySupplier<WorldGeneratorFactory> createFactory(GeneratorContext context) {
        return LazySupplier.factory(context.copy(), WorldGeneratorFactory::new);
    }

    public static GeneratorContext createNoCache(Settings settings) {
        return new GeneratorContext(settings, StandardTerrainProvider::new, s -> null);
    }

    protected static TileProvider createCache(WorldGeneratorFactory factory) {
        return TileGenerator.builder().pool(ThreadPools.createDefault()).factory(factory).size(3, 1).build().cached();
    }
}

