/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.world.biome.map.set;

import com.terrano.engine.cell.Cell;
import com.terrano.engine.world.biome.TempCategory;
import com.terrano.engine.world.biome.map.BiomeContext;
import com.terrano.engine.world.biome.map.BiomeMap;
import com.terrano.engine.world.biome.map.defaults.DefaultBiome;
import com.terrano.engine.world.biome.map.set.TemperatureSet;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;

public class RiverSet
extends TemperatureSet {
    private final BiomeMap<?> biomes;
    private final IntSet overrides;

    public RiverSet(Map<TempCategory, IntList> map, BiomeMap<?> biomes, DefaultBiome defaultBiome, BiomeContext<?> context) {
        super(map, defaultBiome, context);
        this.biomes = biomes;
        this.overrides = context.getRiverOverrides();
    }

    @Override
    public int getBiome(Cell cell) {
        int biome = this.biomes.getLand(cell);
        return biome != Integer.MIN_VALUE && this.overrides.contains(biome) ? biome : super.getBiome(cell);
    }
}

