/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.world.biome.modifier;

import com.terrano.engine.cell.Cell;
import com.terrano.engine.world.GeneratorContext;
import com.terrano.engine.world.biome.map.BiomeMap;
import com.terrano.engine.world.biome.modifier.BiomeModifier;
import com.terrano.noise.Module;
import com.terrano.noise.Source;

public class MountainModifier
implements BiomeModifier {
    public static final float MOUNTAIN_CHANCE = 0.4f;
    private static final int MOUNTAIN_START_HEIGHT = 48;
    private final float chance;
    private final float height;
    private final float range;
    private final Module noise;
    private final BiomeMap biomes;

    public MountainModifier(GeneratorContext context, BiomeMap biomes, float usage) {
        this.biomes = biomes;
        this.chance = usage;
        this.range = context.levels.scale(10);
        this.height = context.levels.ground(48);
        this.noise = Source.perlin(context.seed.next(), 80, 2).scale(this.range);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public boolean exitEarly() {
        return true;
    }

    @Override
    public boolean test(int biome, Cell cell) {
        return cell.terrain.isMountain() && cell.macroBiomeId < this.chance;
    }

    @Override
    public int modify(int in, Cell cell, int x, int z) {
        int mountain;
        if (this.canModify(cell, x, z) && BiomeMap.isValid(mountain = this.biomes.getMountain(cell))) {
            return mountain;
        }
        return in;
    }

    private boolean canModify(Cell cell, int x, int z) {
        if (cell.value > this.height) {
            return true;
        }
        if (cell.value + this.range < this.height) {
            return false;
        }
        return cell.value + this.noise.getValue(x, z) > this.height;
    }
}

