/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.world.biome.modifier;

import com.terrano.engine.cell.Cell;
import com.terrano.engine.world.GeneratorContext;
import com.terrano.engine.world.biome.map.BiomeMap;
import com.terrano.engine.world.biome.modifier.BiomeModifier;
import com.terrano.engine.world.heightmap.Levels;

public class OceanModifier
implements BiomeModifier {
    private final Levels levels;
    private final float controlPoint;
    private final BiomeMap<?> biomeMap;

    public OceanModifier(GeneratorContext context, BiomeMap<?> biomeMap) {
        this.biomeMap = biomeMap;
        this.levels = context.levels;
        this.controlPoint = context.settings.world.controlPoints.beach;
    }

    @Override
    public int priority() {
        return 15;
    }

    @Override
    public boolean test(int biome, Cell cell) {
        return cell.terrain.isOverground() && cell.value < this.levels.water && cell.continentEdge < this.controlPoint;
    }

    @Override
    public int modify(int in, Cell cell, int x, int z) {
        int ocean = this.biomeMap.getShallowOcean(cell);
        return BiomeMap.isValid(ocean) ? ocean : in;
    }
}

