/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.world.biome.modifier;

import com.terrano.engine.cell.Cell;
import com.terrano.engine.world.biome.map.BiomeContext;
import com.terrano.engine.world.biome.modifier.BiomeModifier;
import com.terrano.engine.world.biome.type.BiomeType;

public class WetlandModifier
implements BiomeModifier {
    private final int wetland;
    private final int coldWetland;
    private final int frozenWetland;

    public <T> WetlandModifier(BiomeContext<T> context, T normal, T cold, T frozen) {
        this.wetland = context.getId(normal);
        this.coldWetland = context.getId(cold);
        this.frozenWetland = context.getId(frozen);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public boolean test(int biome, Cell cell) {
        if (cell.biome != BiomeType.TAIGA) {
            if (cell.biome == BiomeType.TUNDRA) {
                return biome == this.coldWetland;
            }
            return false;
        }
        return biome == this.wetland || biome == this.frozenWetland;
    }

    @Override
    public int modify(int in, Cell cell, int x, int z) {
        return cell.biome == BiomeType.TAIGA ? this.coldWetland : this.frozenWetland;
    }
}

