/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.world.biome.type;

import com.terrano.engine.world.biome.type.BiomeType;
import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BiomeTypeColors {
    private static BiomeTypeColors instance = new BiomeTypeColors();
    private final Map<String, Color> colors = new HashMap<String, Color>();

    private BiomeTypeColors() {
        InputStream inputStream = BiomeType.class.getResourceAsStream("/biomes.txt");
        if (inputStream == null) {
            System.err.println("Warning: /biomes.txt not found, using default biome colors");
            this.initDefaultColors();
            return;
        }
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                try {
                    Color color = Color.decode("#" + entry.getValue().toString());
                    this.colors.put(entry.getKey().toString(), color);
                }
                catch (NumberFormatException e) {
                    System.err.println("Invalid color format for biome: " + String.valueOf(entry.getKey()));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.initDefaultColors();
        }
    }

    private void initDefaultColors() {
        this.colors.put("TROPICAL_RAINFOREST", new Color(0x228B22));
        this.colors.put("TEMPERATE_RAINFOREST", new Color(3050327));
        this.colors.put("TEMPERATE_FOREST", new Color(0x228B22));
        this.colors.put("SAVANNA", new Color(12433259));
        this.colors.put("DESERT", new Color(15583663));
        this.colors.put("STEPPE", new Color(12759680));
        this.colors.put("COLD_STEPPE", new Color(0xA9A9A9));
        this.colors.put("GRASSLAND", new Color(0x90EE90));
        this.colors.put("TAIGA", new Color(0x2F4F4F));
        this.colors.put("TUNDRA", new Color(0xDCDCDC));
        this.colors.put("ALPINE", new Color(0xFFFFFF));
    }

    public Color getColor(String name, Color defaultColor) {
        return this.colors.getOrDefault(name, defaultColor);
    }

    public static BiomeTypeColors getInstance() {
        return instance;
    }

    public static void main(String[] args) throws Throwable {
        try (FileWriter writer = new FileWriter("biome_colors.properties");){
            Properties properties = new Properties();
            for (BiomeType type : BiomeType.values()) {
                int r = type.getColor().getRed();
                int g = type.getColor().getGreen();
                int b = type.getColor().getBlue();
                properties.setProperty(type.name(), String.format("%02x%02x%02x", r, g, b));
            }
            properties.store(writer, "terrano BiomeType Hex Colors (do not include hash/pound character)");
        }
    }
}

