/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.world.geology;

import com.terrano.engine.concurrent.Resource;
import com.terrano.engine.concurrent.pool.ObjectPool;

public class DepthBuffer {
    private static final ObjectPool<DepthBuffer> pool = new ObjectPool<Object>(5, DepthBuffer::new);
    private float sum;
    private float[] buffer;

    public void init(int size) {
        this.sum = 0.0f;
        if (this.buffer == null || this.buffer.length < size) {
            this.buffer = new float[size];
        }
    }

    public float getSum() {
        return this.sum;
    }

    public float get(int index) {
        return this.buffer[index];
    }

    public float getDepth(int index) {
        return this.buffer[index] / this.sum;
    }

    public void set(int index, float value) {
        this.sum += value;
        this.buffer[index] = value;
    }

    public static Resource<DepthBuffer> get() {
        return pool.get();
    }
}

