/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.world.heightmap;

import com.terrano.engine.Seed;
import com.terrano.engine.cell.Cell;
import com.terrano.engine.cell.Populator;
import com.terrano.engine.module.Blender;
import com.terrano.engine.settings.Settings;
import com.terrano.engine.settings.TerrainSettings;
import com.terrano.engine.settings.WorldSettings;
import com.terrano.engine.world.GeneratorContext;
import com.terrano.engine.world.climate.Climate;
import com.terrano.engine.world.continent.Continent;
import com.terrano.engine.world.continent.ContinentLerper2;
import com.terrano.engine.world.continent.ContinentLerper3;
import com.terrano.engine.world.heightmap.ControlPoints;
import com.terrano.engine.world.heightmap.Levels;
import com.terrano.engine.world.heightmap.RegionConfig;
import com.terrano.engine.world.rivermap.Rivermap;
import com.terrano.engine.world.terrain.Terrain;
import com.terrano.engine.world.terrain.TerrainType;
import com.terrano.engine.world.terrain.populator.TerrainPopulator;
import com.terrano.engine.world.terrain.provider.TerrainProvider;
import com.terrano.engine.world.terrain.region.RegionLerper;
import com.terrano.engine.world.terrain.region.RegionModule;
import com.terrano.engine.world.terrain.region.RegionSelector;
import com.terrano.engine.world.terrain.special.VolcanoPopulator;
import com.terrano.noise.Module;
import com.terrano.noise.Source;
import com.terrano.noise.func.EdgeFunc;
import com.terrano.noise.func.Interpolation;

public class Heightmap
implements Populator {
    public static final int MOUNTAIN_SCALE = 1000;
    public static final float DEEP_OCEAN_VALUE = 0.1f;
    public static final float SHALLOW_OCEAN_VALUE = 0.25f;
    public static final float BEACH_VALUE = 0.327f;
    public static final float COAST_VALUE = 0.448f;
    public static final float INLAND_VALUE = 0.502f;
    private static final int REGION_SEED_OFFSET = 789124;
    private static final int WARP_SEED_OFFSET = 8934;
    protected final Continent continentGenerator;
    protected final Populator regionModule;
    private final Levels levels;
    private final Climate climate;
    private final Populator root;
    private final TerrainProvider terrainProvider;
    private final float terrainFrequency;

    public Heightmap(GeneratorContext context) {
        Settings settings = context.settings;
        WorldSettings world = context.settings.world;
        ControlPoints controlPoints = new ControlPoints(world.controlPoints);
        Seed regionSeed = context.seed.offset(789124);
        Seed regionWarp = context.seed.offset(8934);
        int regionWarpScale = 400;
        int regionWarpStrength = 200;
        RegionConfig regionConfig = new RegionConfig(regionSeed.get(), context.settings.terrain.general.terrainRegionSize, Source.simplex(regionWarp.next(), regionWarpScale, 1), Source.simplex(regionWarp.next(), regionWarpScale, 1), regionWarpStrength);
        this.levels = context.levels;
        this.terrainFrequency = 1.0f / settings.terrain.general.globalHorizontalScale;
        this.regionModule = new RegionModule(regionConfig);
        Seed mountainSeed = context.seed.offset(context.settings.terrain.general.terrainSeedOffset);
        Module mountainShapeBase = Source.cellEdge(mountainSeed.next(), 1000, EdgeFunc.DISTANCE_2_ADD).warp(mountainSeed.next(), 333, 2, 250.0);
        Module mountainShape = mountainShapeBase.curve(Interpolation.CURVE3).clamp(0.0, 0.9).map(0.0, 1.0);
        this.terrainProvider = context.terrainFactory.create(context, regionConfig, this);
        RegionSelector terrainRegions = new RegionSelector(this.terrainProvider.getPopulators());
        TerrainPopulator terrainRegionBorders = TerrainPopulator.of(TerrainType.FLATS, this.terrainProvider.getLandforms().getLandBase(), this.terrainProvider.getLandforms().plains(context.seed), settings.terrain.steppe);
        RegionLerper terrain = new RegionLerper(terrainRegionBorders, terrainRegions);
        TerrainPopulator mountains = this.register(TerrainType.MOUNTAIN_CHAIN, this.terrainProvider.getLandforms().getLandBase(), this.terrainProvider.getLandforms().mountains(mountainSeed), settings.terrain.mountains);
        this.continentGenerator = world.continent.continentType.create(context.seed, context);
        this.climate = new Climate(this.continentGenerator, context);
        Blender land = new Blender(mountainShape, terrain, mountains, 0.3f, 0.8f, 0.575f);
        ContinentLerper3 oceans = new ContinentLerper3(this.register(TerrainType.DEEP_OCEAN, this.terrainProvider.getLandforms().deepOcean(context.seed.next())), this.register(TerrainType.SHALLOW_OCEAN, Source.constant(context.levels.water(-7))), this.register(TerrainType.COAST, Source.constant(context.levels.water)), controlPoints.deepOcean, controlPoints.shallowOcean, controlPoints.coast);
        this.root = new ContinentLerper2(oceans, land, controlPoints.shallowOcean, controlPoints.inland);
    }

    public TerrainProvider getTerrainProvider() {
        return this.terrainProvider;
    }

    public Populator getRegionModule() {
        return this.regionModule;
    }

    public Levels getLevels() {
        return this.levels;
    }

    @Override
    public void apply(Cell cell, float x, float z) {
        this.applyBase(cell, x, z);
        this.applyRivers(cell, x, z);
        this.applyClimate(cell, x, z);
    }

    public void applyBase(Cell cell, float x, float z) {
        cell.terrain = TerrainType.FLATS;
        this.continentGenerator.apply(cell, x, z);
        this.regionModule.apply(cell, x, z);
        this.root.apply(cell, x *= this.terrainFrequency, z *= this.terrainFrequency);
    }

    public void applyRivers(Cell cell, float x, float z, Rivermap rivermap) {
        rivermap.apply(cell, x, z);
        VolcanoPopulator.modifyVolcanoType(cell, this.levels);
    }

    public void applyClimate(Cell cell, float x, float z) {
        this.climate.apply(cell, x, z);
    }

    public Climate getClimate() {
        return this.climate;
    }

    public Continent getContinent() {
        return this.continentGenerator;
    }

    public Rivermap getRivermap(int x, int z) {
        return this.continentGenerator.getRivermap(x, z);
    }

    public Populator getPopulator(Terrain terrain, int id) {
        return this.terrainProvider.getPopulator(terrain, id);
    }

    private void applyRivers(Cell cell, float x, float z) {
        this.applyRivers(cell, x, z, this.continentGenerator.getRivermap(cell));
    }

    private TerrainPopulator register(Terrain terrain, Module variance) {
        TerrainPopulator populator = TerrainPopulator.of(terrain, variance);
        this.terrainProvider.registerMixable(populator);
        return populator;
    }

    private TerrainPopulator register(Terrain terrain, Module base, Module variance, TerrainSettings.Terrain settings) {
        TerrainPopulator populator = TerrainPopulator.of(terrain, base, variance, settings);
        this.terrainProvider.registerMixable(populator);
        return populator;
    }
}

