/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.world.heightmap;

import com.terrano.engine.cell.Cell;
import com.terrano.engine.concurrent.Resource;
import com.terrano.engine.tile.Tile;
import com.terrano.engine.tile.api.TileProvider;
import com.terrano.engine.tile.chunk.ChunkReader;
import com.terrano.engine.world.GeneratorContext;
import com.terrano.engine.world.WorldGeneratorFactory;
import com.terrano.engine.world.heightmap.Heightmap;
import com.terrano.engine.world.terrain.TerrainType;

public class WorldLookup {
    private final float waterLevel;
    private final float beachLevel;
    private final TileProvider cache;
    private final Heightmap heightmap;

    public WorldLookup(GeneratorContext context) {
        this.cache = (TileProvider)context.cache.get();
        this.heightmap = ((WorldGeneratorFactory)context.worldGenerator.get()).getHeightmap();
        this.waterLevel = context.levels.water;
        this.beachLevel = context.levels.water(5);
    }

    public Resource<Cell> get(int x, int z) {
        ChunkReader chunk = this.cache.getChunk(x >> 4, z >> 4);
        Resource<Cell> cell = Cell.getResource();
        cell.get().copyFrom(chunk.getCell(x & 0xF, z & 0xF));
        return cell;
    }

    public Resource<Cell> getCell(int x, int z) {
        return this.getCell(x, z, false);
    }

    public Resource<Cell> getCell(int x, int z, boolean load) {
        Resource<Cell> resource = Cell.getResource();
        this.applyCell(resource.get(), x, z, load);
        return resource;
    }

    public void applyCell(Cell cell, int x, int z) {
        this.applyCell(cell, x, z, false);
    }

    public void applyCell(Cell cell, int x, int z, boolean load) {
        if (!(load && this.computeAccurate(cell, x, z) || this.computeCached(cell, x, z))) {
            this.compute(cell, x, z);
        }
    }

    private boolean computeAccurate(Cell cell, int x, int z) {
        int rz;
        int rx = this.cache.chunkToRegion(x >> 4);
        Tile tile = this.cache.getTile(rx, rz = this.cache.chunkToRegion(z >> 4));
        Cell c = tile.getCell(x, z);
        if (c != null) {
            cell.copyFrom(c);
        }
        return cell.terrain != null;
    }

    private boolean computeCached(Cell cell, int x, int z) {
        int rz;
        int rx = this.cache.chunkToRegion(x >> 4);
        Tile tile = this.cache.getTileIfPresent(rx, rz = this.cache.chunkToRegion(z >> 4));
        if (tile != null) {
            Cell c = tile.getCell(x, z);
            if (c != null) {
                cell.copyFrom(c);
            }
            return cell.terrain != null;
        }
        return false;
    }

    private void compute(Cell cell, int x, int z) {
        this.heightmap.apply(cell, x, z);
        if (cell.terrain == TerrainType.COAST && cell.value > this.waterLevel && cell.value <= this.beachLevel) {
            cell.terrain = TerrainType.BEACH;
        }
    }
}

