/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.world.rivermap;

import com.terrano.engine.cell.Cell;
import com.terrano.engine.concurrent.cache.Cache;
import com.terrano.engine.concurrent.cache.map.StampedLongMap;
import com.terrano.engine.util.pos.PosUtil;
import com.terrano.engine.world.rivermap.RiverGenerator;
import com.terrano.engine.world.rivermap.Rivermap;
import java.util.concurrent.TimeUnit;

public class RiverCache {
    protected final RiverGenerator generator;
    protected final Cache<Rivermap> cache = new Cache("RiverCache", 32, 5L, 1L, TimeUnit.MINUTES, StampedLongMap::new);

    public RiverCache(RiverGenerator generator) {
        this.generator = generator;
    }

    public Rivermap getRivers(Cell cell) {
        return this.getRivers(cell.continentX, cell.continentZ);
    }

    public Rivermap getRivers(int x, int z) {
        return this.cache.computeIfAbsent(PosUtil.pack(x, z), id -> this.generator.generateRivers(PosUtil.unpackLeft(id), PosUtil.unpackRight(id), id));
    }
}

