/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.world.rivermap;

import com.terrano.engine.cell.Cell;
import com.terrano.engine.concurrent.cache.ExpiringEntry;
import com.terrano.engine.world.heightmap.Heightmap;
import com.terrano.engine.world.rivermap.gen.GenWarp;
import com.terrano.engine.world.rivermap.river.Network;
import com.terrano.noise.domain.Domain;

public class Rivermap
implements ExpiringEntry {
    private final int x;
    private final int z;
    private final Domain lakeWarp;
    private final Domain riverWarp;
    private final Network[] networks;
    private final long timestamp = System.currentTimeMillis();

    public Rivermap(int x, int z, Network[] networks, GenWarp warp) {
        this.x = x;
        this.z = z;
        this.networks = networks;
        this.lakeWarp = warp.lake;
        this.riverWarp = warp.river;
    }

    public void apply(Cell cell, float x, float z) {
        float rx = this.riverWarp.getX(x, z);
        float rz = this.riverWarp.getY(x, z);
        float lx = this.lakeWarp.getOffsetX(rx, rz);
        float lz = this.lakeWarp.getOffsetY(rx, rz);
        for (Network network : this.networks) {
            if (!network.contains(rx, rz)) continue;
            network.carve(cell, rx, rz, lx, lz);
        }
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public static Rivermap get(Cell cell, Rivermap instance, Heightmap heightmap) {
        return Rivermap.get(cell.continentX, cell.continentZ, instance, heightmap);
    }

    public static Rivermap get(int x, int z, Rivermap instance, Heightmap heightmap) {
        return instance != null && x == instance.getX() && z == instance.getZ() ? instance : heightmap.getContinent().getRivermap(x, z);
    }
}

