/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.engine.world.terrain.region;

import com.terrano.engine.cell.Cell;
import com.terrano.engine.cell.Populator;
import com.terrano.engine.world.terrain.populator.TerrainPopulator;
import com.terrano.noise.util.NoiseUtil;
import java.util.LinkedList;
import java.util.List;

public class RegionSelector
implements Populator {
    private final int maxIndex;
    private final Populator[] nodes;

    public RegionSelector(List<Populator> populators) {
        this.nodes = RegionSelector.getWeightedArray(populators);
        this.maxIndex = this.nodes.length - 1;
    }

    @Override
    public void apply(Cell cell, float x, float y) {
        this.get(cell.terrainRegionId).apply(cell, x, y);
    }

    public Populator get(float identity) {
        int index = NoiseUtil.round(identity * (float)this.maxIndex);
        return this.nodes[index];
    }

    /*
     * Unable to fully structure code
     */
    private static Populator[] getWeightedArray(List<Populator> modules) {
        smallest = 3.4028235E38f;
        for (Populator p : modules) {
            if (p instanceof TerrainPopulator) {
                tp = (TerrainPopulator)p;
                if (tp.getWeight() == 0.0f) continue;
                smallest = Math.min(smallest, tp.getWeight());
                continue;
            }
            smallest = Math.min(smallest, 1.0f);
        }
        if (smallest == 3.4028235E38f) {
            return modules.toArray(new Populator[0]);
        }
        result = new LinkedList<Populator>();
        var8 = modules.iterator();
        block1: while (true) {
            if (!var8.hasNext()) {
                if (result.isEmpty()) {
                    return modules.toArray(new Populator[0]);
                }
                return result.toArray(new Populator[0]);
            }
            p = var8.next();
            if (p instanceof TerrainPopulator) {
                tp = (TerrainPopulator)p;
                if (tp.getWeight() == 0.0f) continue;
                var5 = Math.round(tp.getWeight() / smallest);
            } else {
                var5 = Math.round(1.0f / smallest);
            }
            while (true) {
                if (var5-- > 0) ** break;
                continue block1;
                result.add(p);
            }
            break;
        }
    }
}

