/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod;

import com.terrano.mod.Terrano;

public interface Environment {
    public static final boolean DEV_ENV = Environment.hasFlag("dev");
    public static final boolean PROFILING = DEV_ENV || Environment.hasFlag("profiling");
    public static final boolean UNLIMITED = DEV_ENV || Environment.hasFlag("unlimited");
    public static final boolean DEBUGGING = DEV_ENV || Environment.hasFlag("debugging");
    public static final boolean DATA_GEN = Environment.hasFlag("datagen");
    public static final int CORES = Runtime.getRuntime().availableProcessors();

    public static boolean hasFlag(String flag) {
        return System.getProperty(flag) != null;
    }

    public static void log() {
        Terrano.LOG.info("Environment:");
        Terrano.LOG.info("- Dev:       {}", (Object)DEV_ENV);
        Terrano.LOG.info("- Profiling: {}", (Object)PROFILING);
        Terrano.LOG.info("- Unlimited: {}", (Object)UNLIMITED);
        Terrano.LOG.info("- Debugging: {}", (Object)DEBUGGING);
        Terrano.LOG.info("- Data Gen:  {}", (Object)DATA_GEN);
        Terrano.LOG.info("- Cores:     {}", (Object)CORES);
    }
}

