/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod;

import com.google.common.base.Suppliers;
import com.terrano.mod.CommonAPI;
import com.terrano.mod.Environment;
import com.terrano.mod.lifecycle.ModSetup;
import com.terrano.mod.registry.key.RegistryKey;
import com.terrano.mod.worldgen.asset.ClimateType;
import com.terrano.mod.worldgen.asset.NoiseCave;
import com.terrano.mod.worldgen.asset.TerrainNoise;
import com.terrano.mod.worldgen.asset.TerrainType;
import com.terrano.mod.worldgen.asset.VegetationConfig;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Terrano
implements CommonAPI {
    public static final String MODID = "terrano";
    public static final String TITLE = "Terrano";
    public static final String DATAPACK_VERSION = "v1.0";
    public static final Logger LOG = LogManager.getLogger((String)"Terrano");
    public static final ResourceLocation WORLD_PRESET = Terrano.location("normal");
    public static final ResourceLocation DIMENSION_EFFECTS = Terrano.location("overworld");
    public static final RegistryKey<Biome> BIOMES = Terrano.registry("minecraft:worldgen/biome");
    public static final RegistryKey<ClimateType> CLIMATES = Terrano.registry("terrano:worldgen/climate");
    public static final RegistryKey<NoiseCave> CAVES = Terrano.registry("terrano:worldgen/cave");
    public static final RegistryKey<TerrainNoise> TERRAINS = Terrano.registry("terrano:worldgen/terrain/noise");
    public static final RegistryKey<TerrainType> TERRAIN_TYPES = Terrano.registry("terrano:worldgen/terrain/type");
    public static final RegistryKey<VegetationConfig> VEGETATIONS = Terrano.registry("terrano:worldgen/vegetation");
    private final Supplier<Path> path = Suppliers.memoize(path::get);

    protected Terrano(Supplier<Path> path) {
        Environment.log();
        CommonAPI.HOLDER.set(this);
        ModSetup.STAGE.run();
    }

    @Override
    public final Path getContainer() {
        return this.path.get();
    }

    public static ResourceLocation location(String name) {
        if (name.contains(":")) {
            return ResourceLocation.parse((String)name);
        }
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name);
    }

    public static <T> RegistryKey<T> registry(String name) {
        return new RegistryKey(ResourceLocation.parse((String)name));
    }

    public static <T> void register(RegistryKey<T> key, String name, T t) {
        ResourceKey entryKey = ResourceKey.create((ResourceKey)((ResourceKey)key.get()), (ResourceLocation)Terrano.location(name));
        CommonAPI.get().getRegistryManager().register(key, entryKey, t);
    }
}

