/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod;

import com.terrano.mod.TerraRegistries;
import com.terrano.mod.Terrano;
import com.terrano.mod.data.ModRegistries;
import com.terrano.mod.lifecycle.CommonSetup;
import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.biome.Source;
import com.terrano.mod.worldgen.biome.vegetation.template.TemplateManager;
import com.terrano.mod.worldgen.biome.vegetation.template.TreeReplacer;
import java.nio.file.Path;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@Mod(value="terrano")
public class TerranoMod
extends Terrano {
    public TerranoMod(IEventBus modBus, ModContainer modContainer) {
        super(() -> TerranoMod.getModPath(modContainer));
        modBus.addListener(this::onCommonSetup);
        ModRegistries.register(modBus);
        TerraRegistries.register(modBus);
        NeoForge.EVENT_BUS.addListener(this::onServerAboutToStart);
    }

    private void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        RegistryAccess.Frozen registries = server.registryAccess();
        ResourceManager resourceManager = server.getResourceManager();
        StructureTemplateManager structureManager = server.getStructureManager();
        TemplateManager.getInstance().clear();
        TreeReplacer.getInstance().clear();
        TemplateManager.getInstance().load(resourceManager, structureManager);
        TreeReplacer.getInstance().load(resourceManager);
        Terrano.LOG.info("Tree template system initialized: {} templates, {} replacement rules", (Object)TemplateManager.getInstance().getTemplateNames().size(), (Object)(TreeReplacer.getInstance().isLoaded() ? "loaded" : "not loaded"));
        for (ServerLevel level : server.getAllLevels()) {
            ChunkGenerator generator = level.getChunkSource().getGenerator();
            if (!(generator instanceof Generator)) continue;
            Generator terraGenerator = (Generator)generator;
            Terrano.LOG.info("ServerAboutToStart: Ensuring init for {}", (Object)level.dimension().location());
            terraGenerator.forceInitialize((RegistryAccess)registries);
            Source source = terraGenerator.getSource();
            Terrano.LOG.info("  possibleBiomes={}, initialized={}", (Object)source.possibleBiomes().size(), (Object)source.isInitialized());
            if (!source.possibleBiomes().isEmpty()) continue;
            Terrano.LOG.error("  CRITICAL: Still empty! Emergency init...");
            source.initBiomes((RegistryAccess)registries);
            Terrano.LOG.info("  After emergency: possibleBiomes={}", (Object)source.possibleBiomes().size());
        }
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(CommonSetup.STAGE::run);
    }

    private static Path getModPath(ModContainer container) {
        return FMLPaths.CONFIGDIR.get().resolve("terrano");
    }
}

