/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.terrano.engine.util.pos.PosUtil;
import com.terrano.engine.world.terrain.Terrain;
import com.terrano.engine.world.terrain.TerrainType;
import com.terrano.mod.command.Arg;
import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.GeneratorPreset;
import com.terrano.mod.worldgen.Regenerator;
import com.terrano.mod.worldgen.Seeds;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class TCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register(TCommands.getLocateTerrainCommand());
        dispatcher.register(TCommands.getTFCommand());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> root(String name) {
        return (LiteralArgumentBuilder)Commands.literal((String)name).requires(s -> s.hasPermission(2));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> getLocateTerrainCommand() {
        return (LiteralArgumentBuilder)TCommands.root("locateterrain").then(((RequiredArgumentBuilder)Arg.terrainType().then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> TCommands.locate((CommandContext<CommandSourceStack>)c, true)))).executes(c -> TCommands.locate((CommandContext<CommandSourceStack>)c, false)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> getTFCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)TCommands.root("tf").then(Commands.literal((String)"export").then(Commands.literal((String)"structures").executes(TCommands::export)))).then(Commands.literal((String)"regen").then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(TCommands::regen)));
    }

    private static int regen(CommandContext<CommandSourceStack> context) {
        try {
            int radius = IntegerArgumentType.getInteger(context, (String)"radius");
            Vec3 pos = ((CommandSourceStack)context.getSource()).getPosition();
            ChunkPos chunk = new ChunkPos((int)pos.x >> 4, (int)pos.z >> 4);
            Regenerator.regenerateChunks(chunk, radius, ((CommandSourceStack)context.getSource()).getLevel(), (CommandSourceStack)context.getSource());
            return 1;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 1;
        }
    }

    private static int export(CommandContext<CommandSourceStack> context) {
        MutableComponent result = Component.literal((String)"Exported structure settings").withStyle(s -> s.withColor(ChatFormatting.GREEN));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> result, false);
        return 1;
    }

    private static int locate(CommandContext<CommandSourceStack> context, boolean withRadius) throws CommandSyntaxException {
        MutableComponent result;
        ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).getLevel();
        Generator generator = GeneratorPreset.getGenerator(serverLevel);
        if (generator == null) {
            return 1;
        }
        String name = StringArgumentType.getString(context, (String)"terrain");
        Terrain terrain = TerrainType.get(name);
        int radius = withRadius ? IntegerArgumentType.getInteger(context, (String)"radius") : 1;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        BlockPos at = player.blockPosition();
        ChunkGenerator chunkGenerator = serverLevel.getChunkSource().getGenerator();
        if (terrain == null) {
            result = TCommands.text("Invalid terrain: " + name).withStyle(ChatFormatting.RED);
        } else {
            int seed = Seeds.get(serverLevel.getSeed());
            int maxRadius = Math.min(100, radius + 50);
            long pos = generator.getNoiseGenerator().find(seed, at.getX(), at.getZ(), radius, maxRadius, terrain);
            if (pos == 0L) {
                result = TCommands.text("Unable to locate terrain: " + name).withStyle(ChatFormatting.RED);
            } else {
                int x = PosUtil.unpackLeft(pos);
                int z = PosUtil.unpackRight(pos);
                int y = serverLevel.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z);
                result = TCommands.createTerrainTeleportMessage(at, x, y, z, terrain);
            }
        }
        player.sendSystemMessage((Component)result);
        return 1;
    }

    private static Component createTerrainTeleportMessage(BlockPos pos, int x, int y, int z, Terrain terrain) {
        double distance = Math.sqrt(pos.distToCenterSqr((double)x, (double)y, (double)z));
        String commandText = String.format("/tp %s %s %s", x, y, z);
        String distanceText = String.format("%.1f", distance);
        String positionText = String.format("%s;%s;%s", x, y, z);
        return TCommands.text("Found terrain: ").withStyle(ChatFormatting.GREEN).append((Component)TCommands.text(terrain.getName()).withStyle(ChatFormatting.YELLOW)).append((Component)TCommands.text(" Distance: ").withStyle(ChatFormatting.GREEN)).append((Component)TCommands.text(distanceText).withStyle(ChatFormatting.YELLOW)).append((Component)TCommands.text(". ").withStyle(ChatFormatting.GREEN)).append((Component)TCommands.text("Teleport").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, commandText)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)TCommands.text("Location: ").withStyle(ChatFormatting.GREEN).append((Component)TCommands.text(positionText).withStyle(ChatFormatting.YELLOW))))));
    }

    private static MutableComponent text(String message) {
        return Component.literal((String)message);
    }
}

