/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.data;

import com.terrano.mod.Terrano;
import com.terrano.mod.registry.key.EntryKey;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public interface ModBiomes {
    public static final EntryKey<Biome> CAVE = Terrano.BIOMES.entryKey("cave");
    public static final EntryKey<Biome> OAK_FOREST = Terrano.BIOMES.entryKey("oak_forest");

    public static void register() {
        Terrano.LOG.info("ModBiomes registration - biomes are loaded from datapack");
    }

    public static void bootstrap(BootstrapContext<Biome> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter carvers = context.lookup(Registries.CONFIGURED_CARVER);
        BiomeGenerationSettings.Builder caveSettings = new BiomeGenerationSettings.Builder(placedFeatures, carvers);
        caveSettings.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, CavePlacements.LARGE_DRIPSTONE);
        caveSettings.addFeature(GenerationStep.Decoration.UNDERGROUND_DECORATION, CavePlacements.POINTED_DRIPSTONE);
        BiomeGenerationSettings.Builder forestSettings = new BiomeGenerationSettings.Builder(placedFeatures, carvers);
    }
}

