/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.data;

import com.terrano.mod.Terrano;
import com.terrano.mod.util.seed.RandSeed;
import com.terrano.mod.worldgen.asset.NoiseCave;
import com.terrano.mod.worldgen.cave.CaveType;
import com.terrano.noise.Module;
import com.terrano.noise.Source;
import com.terrano.noise.util.NoiseUtil;

public interface ModCaves {
    public static void register() {
        RandSeed seed = new RandSeed(901246L, 500000);
        Terrano.register(Terrano.CAVES, "synapse_high", Factory.synapse(seed.next(), 0.75f, 96, 384));
        Terrano.register(Terrano.CAVES, "synapse_mid", Factory.synapse(seed.next(), 1.0f, 0, 256));
        Terrano.register(Terrano.CAVES, "synapse_low", Factory.synapse(seed.next(), 1.2f, -32, 128));
        Terrano.register(Terrano.CAVES, "mega", Factory.mega(seed.next(), 1.0f, -16, 64));
        Terrano.register(Terrano.CAVES, "mega_deep", Factory.mega(seed.next(), 1.2f, -32, 48));
    }

    public static class Factory {
        static NoiseCave mega(int seed, float scale, int minY, int maxY) {
            int elevationScale = NoiseUtil.floor(200.0f * scale);
            int networkScale = NoiseUtil.floor(250.0f * scale);
            int floorScale = NoiseUtil.floor(50.0f * scale);
            int size = NoiseUtil.floor(30.0f * scale);
            Module elevation = Source.simplex(++seed, elevationScale, 2).map(0.3, 0.7);
            Module shape = Source.simplex(++seed, networkScale, 3).bias(-0.5).abs().scale(2.0).invert().clamp(0.75, 1.0).map(0.0, 1.0);
            Module floor = Source.simplex(++seed, floorScale, 2).clamp(0.0, 0.3).map(0.0, 1.0);
            return new NoiseCave(seed, CaveType.UNIQUE, elevation, shape, floor, size, minY, maxY);
        }

        static NoiseCave synapse(int seed, float scale, int minY, int maxY) {
            int elevationScale = NoiseUtil.floor(350.0f * scale);
            int networkScale = NoiseUtil.floor(180.0f * scale);
            int networkWarpScale = NoiseUtil.floor(20.0f * scale);
            int networkWarpStrength = networkWarpScale / 2;
            int floorScale = NoiseUtil.floor(30.0f * scale);
            int size = NoiseUtil.floor(15.0f * scale);
            Module elevation = Source.simplex(++seed, elevationScale, 3).map(0.1, 0.9);
            Module shape = Source.simplexRidge(++seed, networkScale, 3).warp(++seed, networkWarpScale, 1, networkWarpStrength).clamp(0.35, 0.75).map(0.0, 1.0);
            Module floor = Source.simplex(++seed, floorScale, 2).clamp(0.0, 0.15).map(0.0, 1.0);
            return new NoiseCave(seed, CaveType.GLOBAL, elevation, shape, floor, size, minY, maxY);
        }

        static NoiseCave deepCave(int seed, float scale, int minY, int maxY) {
            int elevationScale = NoiseUtil.floor(300.0f * scale);
            int networkScale = NoiseUtil.floor(350.0f * scale);
            int floorScale = NoiseUtil.floor(70.0f * scale);
            int size = NoiseUtil.floor(40.0f * scale);
            Module elevation = Source.simplex(++seed, elevationScale, 2).map(0.2, 0.8);
            Module shape = Source.simplex(++seed, networkScale, 3).bias(-0.5).abs().scale(2.0).invert().clamp(0.7, 1.0).map(0.0, 1.0);
            Module floor = Source.simplex(++seed, floorScale, 2).clamp(0.0, 0.4).map(0.0, 1.0);
            return new NoiseCave(seed, CaveType.UNIQUE, elevation, shape, floor, size, minY, maxY);
        }

        static NoiseCave abyssCave(int seed, float scale, int minY, int maxY) {
            int elevationScale = NoiseUtil.floor(250.0f * scale);
            int networkScale = NoiseUtil.floor(200.0f * scale);
            int networkWarpScale = NoiseUtil.floor(25.0f * scale);
            int networkWarpStrength = networkWarpScale / 2;
            int floorScale = NoiseUtil.floor(40.0f * scale);
            int size = NoiseUtil.floor(20.0f * scale);
            Module elevation = Source.simplex(++seed, elevationScale, 3).map(0.1, 0.9);
            Module shape = Source.simplexRidge(++seed, networkScale, 4).warp(++seed, networkWarpScale, 1, networkWarpStrength).clamp(0.3, 0.7).map(0.0, 1.0);
            Module floor = Source.simplex(++seed, floorScale, 2).clamp(0.0, 0.2).map(0.0, 1.0);
            return new NoiseCave(seed, CaveType.GLOBAL, elevation, shape, floor, size, minY, maxY);
        }

        public static NoiseCave[] getDefaults() {
            RandSeed seed = new RandSeed(901246L, 500000);
            return new NoiseCave[]{Factory.synapse(seed.next(), 0.75f, 64, 384), Factory.synapse(seed.next(), 1.0f, -16, 256), Factory.synapse(seed.next(), 1.2f, -40, 128), Factory.mega(seed.next(), 1.0f, -32, 64), Factory.mega(seed.next(), 1.2f, -40, 48), Factory.deepCave(seed.next(), 1.3f, -40, 16), Factory.abyssCave(seed.next(), 1.5f, -50, -10)};
        }
    }
}

