/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.data;

import com.terrano.mod.Terrano;
import com.terrano.mod.worldgen.asset.ClimateType;
import com.terrano.mod.worldgen.asset.NoiseCave;
import com.terrano.mod.worldgen.asset.TerrainNoise;
import com.terrano.mod.worldgen.asset.TerrainType;
import com.terrano.mod.worldgen.asset.VegetationConfig;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

public class ModRegistries {
    public static final ResourceKey<Registry<TerrainNoise>> TERRAIN_NOISE_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terrano", (String)"worldgen/terrain/noise"));
    public static final ResourceKey<Registry<TerrainType>> TERRAIN_TYPE_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terrano", (String)"worldgen/terrain/type"));
    public static final ResourceKey<Registry<ClimateType>> CLIMATE_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terrano", (String)"worldgen/climate"));
    public static final ResourceKey<Registry<NoiseCave>> CAVE_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terrano", (String)"worldgen/cave"));
    public static final ResourceKey<Registry<VegetationConfig>> VEGETATION_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"terrano", (String)"worldgen/vegetation"));

    public static void register(IEventBus modBus) {
        modBus.addListener(ModRegistries::registerDatapackRegistries);
    }

    private static void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        Terrano.LOG.info("Registering Terrano datapack registries");
        event.dataPackRegistry(TERRAIN_TYPE_KEY, TerrainType.DIRECT, TerrainType.DIRECT);
        event.dataPackRegistry(TERRAIN_NOISE_KEY, TerrainNoise.CODEC, TerrainNoise.CODEC);
        event.dataPackRegistry(CLIMATE_KEY, ClimateType.CODEC, ClimateType.CODEC);
        event.dataPackRegistry(CAVE_KEY, NoiseCave.CODEC, NoiseCave.CODEC);
        event.dataPackRegistry(VEGETATION_KEY, VegetationConfig.CODEC, VegetationConfig.CODEC);
        Terrano.LOG.info("Terrano datapack registries registered");
    }
}

