/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.data;

import com.terrano.engine.Seed;
import com.terrano.engine.settings.TerrainSettings;
import com.terrano.engine.world.heightmap.Levels;
import com.terrano.engine.world.terrain.LandForms;
import com.terrano.engine.world.terrain.Terrain;
import com.terrano.mod.Terrano;
import com.terrano.mod.data.ModTerrainTypes;
import com.terrano.mod.util.seed.RandSeed;
import com.terrano.mod.worldgen.asset.TerrainNoise;
import com.terrano.mod.worldgen.asset.TerrainType;
import com.terrano.noise.Module;
import com.terrano.noise.Source;
import com.terrano.noise.domain.Domain;
import java.util.function.BiFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;

public interface ModTerrains {
    public static void register() {
        Seed seed = Factory.createSeed();
        Terrano.register(Terrano.TERRAINS, "steppe", Factory.create(null, seed, com.terrano.engine.world.terrain.TerrainType.FLATS, 1.5f, LandForms::steppe));
        Terrano.register(Terrano.TERRAINS, "plains", Factory.create(null, seed, com.terrano.engine.world.terrain.TerrainType.FLATS, 2.5f, LandForms::plains));
        Terrano.register(Terrano.TERRAINS, "hills_1", Factory.create(null, seed, com.terrano.engine.world.terrain.TerrainType.HILLS, 2.0f, LandForms::hills1));
        Terrano.register(Terrano.TERRAINS, "hills_2", Factory.create(null, seed, com.terrano.engine.world.terrain.TerrainType.HILLS, 2.0f, LandForms::hills2));
        Terrano.register(Terrano.TERRAINS, "dales", Factory.create(null, seed, com.terrano.engine.world.terrain.TerrainType.HILLS, 1.5f, LandForms::dales));
        Terrano.register(Terrano.TERRAINS, "plateau", Factory.create(null, seed, com.terrano.engine.world.terrain.TerrainType.PLATEAU, 2.0f, LandForms::plateau));
        Terrano.register(Terrano.TERRAINS, "badlands", Factory.create(null, seed, com.terrano.engine.world.terrain.TerrainType.BADLANDS, 1.75f, LandForms::badlands));
        Terrano.register(Terrano.TERRAINS, "torridonian", Factory.create(null, seed, ModTerrainTypes.TORRIDONIAN, 2.5f, LandForms::torridonian));
        Terrano.register(Terrano.TERRAINS, "mountains_1", Factory.create(null, seed, com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.25f, LandForms::mountains));
        Terrano.register(Terrano.TERRAINS, "mountains_2", Factory.create(null, seed, com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.25f, LandForms::mountains2));
        Terrano.register(Terrano.TERRAINS, "mountains_3", Factory.create(null, seed, com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.25f, LandForms::mountains3));
        Terrano.register(Terrano.TERRAINS, "dolomites", Factory.createDolomite(null, seed, ModTerrainTypes.DOLOMITES, 1.25f));
        Terrano.register(Terrano.TERRAINS, "mountains_ridge_1", Factory.createNF(null, seed, com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.25f, LandForms::mountains2));
        Terrano.register(Terrano.TERRAINS, "mountains_ridge_2", Factory.createNF(null, seed, com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.25f, LandForms::mountains3));
    }

    public static class Factory {
        static final LandForms LAND_FORMS = new LandForms(Factory.settings(), new Levels(63, 255), Source.ZERO);
        static final LandForms LAND_FORMS_NF = new LandForms(Factory.nonFancy(), new Levels(63, 255), Source.ZERO);

        static Seed createSeed() {
            return new RandSeed(9712416L, 500000);
        }

        static TerrainNoise create(RegistryAccess access, Seed seed, Terrain type, float weight, BiFunction<LandForms, Seed, Module> factory) {
            return new TerrainNoise(Factory.getType(access, type), weight, factory.apply(LAND_FORMS, seed));
        }

        static TerrainNoise createNF(RegistryAccess access, Seed seed, Terrain type, float weight, BiFunction<LandForms, Seed, Module> factory) {
            return new TerrainNoise(Factory.getType(access, type), weight, factory.apply(LAND_FORMS_NF, seed));
        }

        static TerrainNoise createDolomite(RegistryAccess access, Seed seed, Terrain type, float weight) {
            Module base = Source.simplex(seed.next(), 80, 4).scale(0.1);
            Module shape = Source.simplex(seed.next(), 475, 4).clamp(0.3, 1.0).map(0.0, 1.0).warp(seed.next(), 10, 2, 8.0);
            Module slopes = shape.pow(2.2).scale(0.65).add(base);
            Module peaks = Source.build(seed.next(), 400, 5).lacunarity(2.7).gain(0.6).simplexRidge().clamp(0.0, 0.675).map(0.0, 1.0).warp(Domain.warp(Source.SIMPLEX, seed.next(), 40, 5, 30.0)).alpha(0.875);
            Module noise = shape.mult(peaks).max(slopes).warp(seed.next(), 800, 3, 300.0).scale(0.75);
            return new TerrainNoise(Factory.getType(access, type), weight, noise);
        }

        static Holder<TerrainType> getType(RegistryAccess access, Terrain terrain) {
            return Terrano.TERRAIN_TYPES.holder(terrain.getName(), access, () -> TerrainType.of(terrain));
        }

        static TerrainSettings settings() {
            TerrainSettings settings = new TerrainSettings();
            settings.general.globalVerticalScale = 1.0f;
            return settings;
        }

        static TerrainSettings nonFancy() {
            TerrainSettings settings = Factory.settings();
            settings.general.fancyMountains = false;
            return settings;
        }

        public static TerrainNoise[] getDefault(RegistryAccess access) {
            Seed seed = Factory.createSeed();
            return new TerrainNoise[]{Factory.create(access, seed, com.terrano.engine.world.terrain.TerrainType.FLATS, 1.5f, LandForms::steppe), Factory.create(access, seed, com.terrano.engine.world.terrain.TerrainType.FLATS, 2.5f, LandForms::plains), Factory.create(access, seed, com.terrano.engine.world.terrain.TerrainType.HILLS, 2.0f, LandForms::hills1), Factory.create(access, seed, com.terrano.engine.world.terrain.TerrainType.HILLS, 2.0f, LandForms::hills2), Factory.create(access, seed, com.terrano.engine.world.terrain.TerrainType.HILLS, 1.5f, LandForms::dales), Factory.create(access, seed, com.terrano.engine.world.terrain.TerrainType.PLATEAU, 2.0f, LandForms::plateau), Factory.create(access, seed, com.terrano.engine.world.terrain.TerrainType.BADLANDS, 1.75f, LandForms::badlands), Factory.create(access, seed, ModTerrainTypes.TORRIDONIAN, 2.5f, LandForms::torridonian), Factory.create(access, seed, com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.25f, LandForms::mountains), Factory.create(access, seed, com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.25f, LandForms::mountains2), Factory.create(access, seed, com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.25f, LandForms::mountains3), Factory.createDolomite(access, seed, ModTerrainTypes.DOLOMITES, 1.25f), Factory.createNF(access, seed, com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.25f, LandForms::mountains2), Factory.createNF(access, seed, com.terrano.engine.world.terrain.TerrainType.MOUNTAINS, 1.25f, LandForms::mountains3)};
        }
    }

    public static interface Weights {
        public static final float STEPPE = 1.5f;
        public static final float PLAINS = 2.5f;
        public static final float HILLS = 2.0f;
        public static final float DALES = 1.5f;
        public static final float PLATEAU = 2.0f;
        public static final float BADLANDS = 1.75f;
        public static final float TORRIDONIAN = 2.5f;
        public static final float MOUNTAINS = 1.25f;
    }
}

