/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.data.gen;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.terrano.mod.CommonAPI;
import com.terrano.mod.Terrano;
import com.terrano.mod.data.codec.Codecs;
import com.terrano.mod.data.gen.EncodingException;
import com.terrano.mod.data.util.JsonFormatter;
import com.terrano.mod.registry.DataRegistry;
import com.terrano.mod.util.FileUtil;
import com.terrano.mod.util.TagLoader;
import com.terrano.mod.worldgen.GeneratorPreset;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;

public class DataGen {
    private final CachedOutput cache;
    private final List<CompletableFuture<?>> tasks = new ObjectArrayList();

    public DataGen(CachedOutput cache) {
        this.cache = cache;
    }

    protected CompletableFuture<?> doExport(Path dir) {
        FileUtil.delete(dir);
        RegistryAccess.Frozen registries = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        RegistryOps writeOps = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registries);
        TagLoader.bindTags((RegistryAccess)registries);
        this.genPreset(dir, (RegistryAccess)registries, (RegistryOps<JsonElement>)writeOps);
        this.genBuiltin(dir, (RegistryAccess)registries, (RegistryOps<JsonElement>)writeOps);
        this.genDimensionType(dir, (RegistryAccess)registries, (RegistryOps<JsonElement>)writeOps);
        return CompletableFuture.allOf((CompletableFuture[])this.tasks.toArray(CompletableFuture[]::new));
    }

    public static CompletableFuture<?> export(Path dir, CachedOutput cache) {
        return new DataGen(cache).doExport(dir);
    }

    private void genPreset(Path dir, RegistryAccess registries, RegistryOps<JsonElement> writeOps) {
        Registry presetRegistry = registries.registryOrThrow(Registries.WORLD_PRESET);
        WorldPreset normal = (WorldPreset)presetRegistry.get(WorldPresets.NORMAL);
        if (normal == null) {
            Terrano.LOG.warn("NORMAL world preset not found");
            return;
        }
        JsonObject json = Codecs.encode(normal, WorldPreset.DIRECT_CODEC, writeOps).getAsJsonObject();
        LevelStem dimension = GeneratorPreset.getDefault(registries);
        JsonElement dimensionJson = Codecs.encode(dimension, LevelStem.CODEC, writeOps);
        JsonObject dimensions = json.getAsJsonObject("dimensions");
        dimensions.add(LevelStem.OVERWORLD.location().toString(), dimensionJson);
        this.export(dir, Registries.WORLD_PRESET, Terrano.WORLD_PRESET, (JsonElement)json);
    }

    private void genDimensionType(Path dir, RegistryAccess registries, RegistryOps<JsonElement> writeOps) {
        Registry registry = registries.registryOrThrow(Registries.DIMENSION_TYPE);
        DimensionType overworld = (DimensionType)registry.get(BuiltinDimensionTypes.OVERWORLD);
        if (overworld == null) {
            Terrano.LOG.warn("OVERWORLD dimension type not found");
            return;
        }
        JsonObject json = Codecs.encode(overworld, DimensionType.DIRECT_CODEC, writeOps).getAsJsonObject();
        json.addProperty("height", (Number)1024);
        json.addProperty("logical_height", (Number)1024);
        json.addProperty("effects", Terrano.DIMENSION_EFFECTS.toString());
        this.export(dir, Registries.DIMENSION_TYPE, BuiltinDimensionTypes.OVERWORLD.location(), (JsonElement)json);
    }

    private void genBuiltin(Path dir, RegistryAccess registries, RegistryOps<JsonElement> writeOps) {
        for (DataRegistry<?> registry : CommonAPI.get().getRegistryManager().getRegistries()) {
            this.export(dir, registry, registries, (DynamicOps<JsonElement>)writeOps);
        }
    }

    private <T> void export(Path dir, DataRegistry<T> builtin, RegistryAccess access, DynamicOps<JsonElement> ops) {
        ResourceKey registryKey = (ResourceKey)builtin.key().get();
        Optional optRegistry = access.registry(registryKey);
        if (optRegistry.isEmpty()) {
            Terrano.LOG.warn("Registry not found: {}", (Object)registryKey);
            return;
        }
        Registry registry = (Registry)optRegistry.get();
        Terrano.LOG.info("Exporting registry: {}", (Object)registryKey);
        for (Map.Entry<ResourceKey<T>, T> entry : builtin) {
            try {
                Object value = registry.get(entry.getKey());
                if (value == null) continue;
                JsonElement json = (JsonElement)builtin.codec().encodeStart(ops, value).mapError(s -> {
                    DataGen.logError(s);
                    return s;
                }).result().orElseThrow();
                this.export(dir, registryKey, entry.getKey().location(), json);
            }
            catch (Throwable t) {
                new EncodingException(entry.getKey(), t).printStackTrace();
            }
        }
    }

    private void export(Path dir, ResourceKey<?> registry, ResourceLocation name, JsonElement json) {
        Path file = dir.resolve("data").resolve(name.getNamespace()).resolve(registry.location().getPath()).resolve(name.getPath() + ".json");
        if (this.cache != null) {
            this.writeCached(file, json);
        } else {
            this.tasks.add(CompletableFuture.runAsync(() -> this.writeDirect(file, json)));
        }
    }

    protected void writeDirect(Path path, JsonElement json) {
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try (BufferedWriter out = Files.newBufferedWriter(path, new OpenOption[0]);){
            JsonFormatter.format(json, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeCached(Path path, JsonElement json) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            HashingOutputStream hashOut = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteOut);
            JsonFormatter.format(json, (OutputStream)hashOut);
            this.cache.writeIfNeeded(path, byteOut.toByteArray(), hashOut.hash());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String logError(String s) {
        Terrano.LOG.warn(s);
        return s;
    }
}

