/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.hooks;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.terrano.mod.Environment;
import com.terrano.mod.Terrano;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.common.conditions.ConditionalOps;

public class RegistryAccessUtil {
    private static Field conditionalOpsDelegate = null;
    private static Field registryOpsDelegate = null;

    public static Optional<RegistryAccess> getRegistryAccess(DynamicOps<?> ops) {
        try {
            DynamicOps<?> unwrapped = RegistryAccessUtil.unwrapConditionalOps(ops);
            RegistryOps registryOps = null;
            if (unwrapped instanceof RegistryOps) {
                RegistryOps ro;
                registryOps = ro = (RegistryOps)unwrapped;
            } else if (ops instanceof RegistryOps) {
                RegistryOps ro;
                registryOps = ro = (RegistryOps)ops;
            }
            if (registryOps == null) {
                Terrano.LOG.warn("Could not find RegistryOps in: {}", (Object)ops.getClass().getName());
                return Optional.empty();
            }
            RegistryAccess access = RegistryAccessUtil.extractRegistryAccess(registryOps);
            if (access == null) {
                Terrano.LOG.warn("Could not extract RegistryAccess from RegistryOps");
            }
            return Optional.ofNullable(access);
        }
        catch (Throwable t) {
            Terrano.LOG.error("Error getting RegistryAccess", t);
            return Optional.empty();
        }
    }

    private static DynamicOps<?> unwrapConditionalOps(DynamicOps<?> ops) {
        if (!(ops instanceof ConditionalOps)) {
            return ops;
        }
        if (conditionalOpsDelegate != null) {
            try {
                Object delegate = conditionalOpsDelegate.get(ops);
                if (delegate instanceof DynamicOps) {
                    DynamicOps delegateOps = (DynamicOps)delegate;
                    Terrano.LOG.debug("Unwrapped ConditionalOps -> {}", (Object)delegateOps.getClass().getSimpleName());
                    return delegateOps;
                }
            }
            catch (Throwable e) {
                Terrano.LOG.debug("Failed to unwrap ConditionalOps via field: {}", (Object)e.getMessage());
            }
        }
        return ops;
    }

    private static RegistryAccess extractRegistryAccess(RegistryOps<?> ops) {
        RegistryOps.RegistryInfoLookup infoLookup = ops.lookupProvider;
        Terrano.LOG.debug("RegistryInfoLookup type: {}", (Object)infoLookup.getClass().getName());
        if (infoLookup instanceof RegistryOps.HolderLookupAdapter) {
            RegistryOps.HolderLookupAdapter adapter = (RegistryOps.HolderLookupAdapter)infoLookup;
            HolderLookup.Provider provider = adapter.lookupProvider;
            Terrano.LOG.debug("HolderLookupAdapter.lookupProvider type: {}", (Object)provider.getClass().getName());
            return RegistryAccessUtil.extractFromProvider(provider);
        }
        return RegistryAccessUtil.extractFromRegistryInfoLookup(infoLookup, ops);
    }

    private static RegistryAccess extractFromRegistryInfoLookup(RegistryOps.RegistryInfoLookup infoLookup, RegistryOps<?> ops) {
        RegistryAccess access;
        Class clazz = infoLookup.getClass();
        Terrano.LOG.debug("Extracting from RegistryInfoLookup: {}", (Object)clazz.getName());
        for (Class currentClass = clazz; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                try {
                    HolderLookup.Provider provider;
                    RegistryAccess access2;
                    field.setAccessible(true);
                    Object value = field.get(infoLookup);
                    Terrano.LOG.debug("  Checking field {}: {} = {}", (Object)field.getName(), (Object)field.getType().getSimpleName(), (Object)(value != null ? value.getClass().getSimpleName() : "null"));
                    if (value instanceof RegistryAccess) {
                        access = (RegistryAccess)value;
                        Terrano.LOG.info("Found RegistryAccess in field: {}", (Object)field.getName());
                        return access;
                    }
                    if (value instanceof RegistryAccess.Frozen) {
                        RegistryAccess.Frozen frozen = (RegistryAccess.Frozen)value;
                        Terrano.LOG.info("Found RegistryAccess.Frozen in field: {}", (Object)field.getName());
                        return frozen;
                    }
                    if (!(value instanceof HolderLookup.Provider) || (access2 = RegistryAccessUtil.extractFromProvider(provider = (HolderLookup.Provider)value)) == null) continue;
                    Terrano.LOG.info("Extracted RegistryAccess from Provider in field: {}", (Object)field.getName());
                    return access2;
                }
                catch (Throwable value) {
                    // empty catch block
                }
            }
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().startsWith("this$") && !field.getName().equals("val$owner")) continue;
            try {
                field.setAccessible(true);
                Object outer = field.get(infoLookup);
                Terrano.LOG.debug("Checking outer/captured field {}: {}", (Object)field.getName(), (Object)(outer != null ? outer.getClass().getName() : "null"));
                if (outer == null || (access = RegistryAccessUtil.extractFromObject(outer)) == null) continue;
                return access;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return RegistryAccessUtil.buildRegistryAccessFromOps(ops);
    }

    private static RegistryAccess extractFromObject(Object obj) {
        if (obj instanceof RegistryAccess) {
            RegistryAccess access = (RegistryAccess)obj;
            return access;
        }
        if (obj instanceof HolderLookup.Provider) {
            HolderLookup.Provider provider = (HolderLookup.Provider)obj;
            return RegistryAccessUtil.extractFromProvider(provider);
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            try {
                HolderLookup.Provider provider;
                RegistryAccess access;
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value instanceof RegistryAccess) {
                    RegistryAccess access2 = (RegistryAccess)value;
                    Terrano.LOG.debug("Found RegistryAccess in {}.{}", (Object)obj.getClass().getSimpleName(), (Object)field.getName());
                    return access2;
                }
                if (!(value instanceof HolderLookup.Provider) || (access = RegistryAccessUtil.extractFromProvider(provider = (HolderLookup.Provider)value)) == null) continue;
                return access;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static RegistryAccess extractFromProvider(HolderLookup.Provider provider) {
        if (provider instanceof RegistryAccess) {
            RegistryAccess access = (RegistryAccess)provider;
            return access;
        }
        if (provider instanceof RegistryAccess.Frozen) {
            RegistryAccess.Frozen frozen = (RegistryAccess.Frozen)provider;
            return frozen;
        }
        try {
            List registries = provider.listRegistries().flatMap(lookup -> {
                if (lookup instanceof Registry) {
                    Registry registry = (Registry)lookup;
                    return Stream.of(registry);
                }
                return Stream.empty();
            }).toList();
            if (!registries.isEmpty()) {
                Terrano.LOG.debug("Built ImmutableRegistryAccess from {} registries", (Object)registries.size());
                return new RegistryAccess.ImmutableRegistryAccess(registries);
            }
        }
        catch (Throwable e) {
            Terrano.LOG.debug("Failed to build RegistryAccess from provider: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static RegistryAccess buildRegistryAccessFromOps(RegistryOps<?> ops) {
        Terrano.LOG.debug("Attempting to build RegistryAccess from ops.getter()");
        return null;
    }

    public static <T> MappedRegistry<T> copy(Registry<T> input) {
        MappedRegistry copy = new MappedRegistry(input.key(), input.registryLifecycle(), true);
        for (Map.Entry entry : input.entrySet()) {
            RegistrationInfo info = new RegistrationInfo(Optional.empty(), Lifecycle.stable());
            copy.register((ResourceKey)entry.getKey(), entry.getValue(), info);
        }
        return copy;
    }

    public static <T> void copy(Registry<T> registry, RegistryAccess access) {
        Registry dest = access.registryOrThrow(registry.key());
        if (dest instanceof WritableRegistry) {
            WritableRegistry writable = (WritableRegistry)dest;
            for (Map.Entry entry : registry.entrySet()) {
                if (dest.containsKey((ResourceKey)entry.getKey())) continue;
                RegistrationInfo info = new RegistrationInfo(Optional.empty(), Lifecycle.stable());
                writable.register((ResourceKey)entry.getKey(), entry.getValue(), info);
            }
        }
    }

    public static void printRegistryContents(Registry<?> registry) {
        if (!Environment.DEBUGGING) {
            return;
        }
        Terrano.LOG.info(" - Registry: {}, Size: {}", (Object)registry.key().location(), (Object)registry.size());
        for (Map.Entry entry : registry.entrySet()) {
            Terrano.LOG.info("  - {}", (Object)((ResourceKey)entry.getKey()).location());
        }
    }

    static {
        try {
            for (Field field : RegistryOps.class.getDeclaredFields()) {
                if (!DynamicOps.class.isAssignableFrom(field.getType()) || RegistryOps.RegistryInfoLookup.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                registryOpsDelegate = field;
                Terrano.LOG.info("Found RegistryOps delegate field: {} of type {}", (Object)field.getName(), (Object)field.getType().getSimpleName());
                break;
            }
            for (Field field : ConditionalOps.class.getDeclaredFields()) {
                if (!DynamicOps.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                conditionalOpsDelegate = field;
                Terrano.LOG.info("Found ConditionalOps delegate field: {} of type {}", (Object)field.getName(), (Object)field.getType().getSimpleName());
                break;
            }
        }
        catch (Throwable e) {
            Terrano.LOG.error("Failed to initialize RegistryAccessUtil", e);
        }
    }
}

