/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.mixin.common;

import com.terrano.mod.Terrano;
import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.biome.Source;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer {
    @Shadow
    @Final
    private Map<ResourceKey<Level>, ServerLevel> levels;

    @Shadow
    public abstract RegistryAccess.Frozen registryAccess();

    @Inject(method={"createLevels"}, at={@At(value="HEAD")})
    private void terrano$beforeCreateLevels(CallbackInfo ci) {
        RegistryAccess.Frozen access = this.registryAccess();
        Generator.PENDING_REGISTRY_ACCESS.set((RegistryAccess)access);
        Terrano.LOG.info("[Mixin] beforeCreateLevels: Set PENDING_REGISTRY_ACCESS");
    }

    @Inject(method={"createLevels"}, at={@At(value="TAIL")})
    private void terrano$afterCreateLevels(CallbackInfo ci) {
        Generator.PENDING_REGISTRY_ACCESS.set(null);
        RegistryAccess.Frozen access = this.registryAccess();
        for (Map.Entry<ResourceKey<Level>, ServerLevel> entry : this.levels.entrySet()) {
            ServerLevel level = entry.getValue();
            ChunkGenerator generator = level.getChunkSource().getGenerator();
            if (!(generator instanceof Generator)) continue;
            Generator terraGenerator = (Generator)generator;
            Source source = terraGenerator.getSource();
            if (!source.isInitialized()) {
                terraGenerator.forceInitialize((RegistryAccess)access);
            }
            if (source.possibleBiomes().isEmpty()) {
                Terrano.LOG.error("[Mixin] EMERGENCY: possibleBiomes still empty for {}!", (Object)entry.getKey().location());
                source.initBiomes((RegistryAccess)access);
            }
            Terrano.LOG.info("[Mixin] afterCreateLevels: {} - possibleBiomes={}, init={}", (Object)entry.getKey().location(), (Object)source.possibleBiomes().size(), (Object)source.isInitialized());
        }
    }
}

