/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.mixin.common;

import com.terrano.mod.Terrano;
import com.terrano.mod.worldgen.Generator;
import com.terrano.mod.worldgen.biome.Source;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public class MixinServerLevel {
    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void terrano$afterInit(MinecraftServer server, Executor executor, LevelStorageSource.LevelStorageAccess storageAccess, ServerLevelData levelData, ResourceKey<Level> dimension, LevelStem levelStem, ChunkProgressListener progressListener, boolean isDebug, long biomeZoomSeed, List<?> customSpawners, boolean tickTime, RandomSequences randomSequences, CallbackInfo ci) {
        ChunkGenerator chunkGenerator = levelStem.generator();
        if (chunkGenerator instanceof Generator) {
            Generator terraGenerator = (Generator)chunkGenerator;
            RegistryAccess.Frozen access = server.registryAccess();
            Source source = terraGenerator.getSource();
            Terrano.LOG.info("[Mixin] ServerLevel TAIL: {} - possibleBiomes={}", (Object)dimension.location(), (Object)source.possibleBiomes().size());
            if (!source.isInitialized()) {
                terraGenerator.setEarlyRegistryAccess((RegistryAccess)access);
                source.initBiomes((RegistryAccess)access);
                terraGenerator.forceInitialize((RegistryAccess)access);
                Terrano.LOG.info("[Mixin] ServerLevel TAIL: Initialized - possibleBiomes={}", (Object)source.possibleBiomes().size());
            }
        }
    }
}

