/*
 * Decompiled with CFR 0.152.
 */
package com.terrano.mod.registry.key;

import com.terrano.mod.CommonAPI;
import com.terrano.mod.Terrano;
import com.terrano.mod.registry.key.EntryKey;
import com.terrano.mod.registry.lazy.LazyHolder;
import com.terrano.mod.registry.lazy.LazyValue;
import java.util.Comparator;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RegistryKey<T>
extends LazyValue<ResourceKey<Registry<T>>> {
    public RegistryKey(ResourceLocation name) {
        super(name);
    }

    public EntryKey<T> entryKey(String name) {
        return new EntryKey(this, Terrano.location(name));
    }

    public Holder<T> holder(String name, RegistryAccess access, Supplier<T> defaultSupplier) {
        EntryKey<T> key = this.entryKey(name);
        if (access == null) {
            return new LazyHolder<T>(defaultSupplier.get(), key);
        }
        return access.registryOrThrow((ResourceKey)this.get()).getHolderOrThrow((ResourceKey)key.get());
    }

    public T[] entries(RegistryAccess access, IntFunction<T[]> arrayFunc) {
        if (access == null) {
            return RegistryKey.toSortedArray(CommonAPI.get().getRegistryManager().getRegistry(this).stream(), arrayFunc);
        }
        return RegistryKey.toSortedArray(access.registryOrThrow((ResourceKey)this.get()).entrySet().stream(), arrayFunc);
    }

    @Override
    protected ResourceKey<Registry<T>> compute() {
        return ResourceKey.createRegistryKey((ResourceLocation)this.name);
    }

    public String toString() {
        return "RegistryKey{" + String.valueOf(this.name) + "}";
    }

    private static <T> T[] toSortedArray(Stream<Map.Entry<ResourceKey<T>, T>> stream, IntFunction<T[]> arrayFunc) {
        return stream.sorted(Comparator.comparing(e -> ((ResourceKey)e.getKey()).location())).map(Map.Entry::getValue).toArray(arrayFunc);
    }
}

